/*
 * Decompiled with CFR 0.152.
 */
package wordlengthoptimization;

import datapath.graph.Graph;
import datapath.graph.display.DisplayFactory;
import datapath.graph.display.dot.DotDisplayFactory;
import datapath.graph.operations.Operation;
import datapath.graph.operations.ParentInput;
import datapath.graph.operations.ParentOutput;
import datapath.graph.type.FixedPoint;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import wordlengthoptimization.ComputeIntegerValueVisitor;
import wordlengthoptimization.ComputeValueVisitor;
import wordlengthoptimization.ForwardPropagationVisitorNewTypeCast;
import wordlengthoptimization.LimitBitwidthNewTypeCast;
import wordlengthoptimization.Options;
import wordlengthoptimization.RemoveTypeConversion;
import wordlengthoptimization.ShiftInserterNewTypeCast;
import wordlengthoptimization.Util;
import wordlengthoptimization.WordlengthOptimization;

public class ForwardPropagation
implements WordlengthOptimization {
    private Options opts;
    private Graph graph;
    HashMap<Operation, Double> minValues = new HashMap();
    HashMap<Operation, Double> maxValues = new HashMap();
    ArrayList<HashMap<ParentInput, Double>> monteCarloInputsFloat = new ArrayList();
    ArrayList<HashMap<ParentInput, BigInteger>> monteCarloInputsFix = new ArrayList();
    ArrayList<HashMap<Operation, Double>> monteCarloResultsFloat = new ArrayList();
    ArrayList<HashMap<Operation, BigInteger>> monteCarloResultsFix = new ArrayList();

    private HashMap<Operation, Double> performMonteCarloIter(HashMap<ParentInput, Double> startValues) {
        ComputeValueVisitor computeValue = new ComputeValueVisitor(startValues);
        Operation.nextVisit();
        for (ParentOutput outputNode : this.graph.getOutput()) {
            outputNode.postOrderUpwardVisit(computeValue);
        }
        return computeValue.getValues();
    }

    private void initStartVariableRanges() {
        for (ParentInput input : this.graph.getInput()) {
            String strMin = this.opts.getStartVariableMinValues().get(input.getName());
            String strMax = this.opts.getStartVariableMaxValues().get(input.getName());
            this.minValues.put(input, Double.parseDouble(strMin));
            this.maxValues.put(input, Double.parseDouble(strMax));
        }
    }

    private HashMap<ParentInput, Double> generateTrace(double pwx, double pwy, double pwz) {
        HashMap<ParentInput, Double> traceValue = new HashMap<ParentInput, Double>();
        for (ParentInput input : this.graph.getInput()) {
            if (input.getName().equals("pwx")) {
                traceValue.put(input, 0.0);
            }
            if (input.getName().equals("pwy")) {
                traceValue.put(input, 1.4);
            }
            if (!input.getName().equals("pwz")) continue;
            traceValue.put(input, -1.0);
        }
        return traceValue;
    }

    private void generateMonteCarloFloatInputs() {
        this.monteCarloInputsFloat.add(this.generateTrace(0.0, 1.4, -1.0));
        for (int iter = 0; iter < this.opts.getMonteCarloIterations(); ++iter) {
            HashMap<ParentInput, Double> startValues = new HashMap<ParentInput, Double>();
            for (ParentInput input : this.graph.getInput()) {
                double minValue = this.minValues.get(input);
                double maxValue = this.maxValues.get(input);
                double range = maxValue - minValue;
                double randomValue = minValue + Math.random() * range;
                startValues.put(input, randomValue);
            }
            this.monteCarloInputsFloat.add(startValues);
        }
    }

    private void generateMonteCarloFixInputsFromFloats() {
        ArrayList newFloatValues = new ArrayList();
        for (HashMap<ParentInput, Double> floatValues : this.monteCarloInputsFloat) {
            HashMap<ParentInput, BigInteger> startValues = new HashMap<ParentInput, BigInteger>();
            HashMap<ParentInput, Double> newFloatStartValues = new HashMap<ParentInput, Double>();
            for (ParentInput input : floatValues.keySet()) {
                FixedPoint fpt = (FixedPoint)input.getType();
                startValues.put(input, Util.fixedPointFromFloat(floatValues.get(input), fpt.getFractionlength()));
                newFloatStartValues.put(input, Util.floatFromfixedPoint((BigInteger)startValues.get(input), fpt.getFractionlength()));
            }
            this.monteCarloInputsFix.add(startValues);
            newFloatValues.add(newFloatStartValues);
        }
        this.monteCarloInputsFloat = newFloatValues;
    }

    private void generateMonteCarloInputs() {
        this.initStartVariableRanges();
        this.generateMonteCarloFloatInputs();
        this.generateMonteCarloFixInputsFromFloats();
    }

    private void monteCarloFix() {
        int i = 0;
        for (HashMap<ParentInput, BigInteger> startValues : this.monteCarloInputsFix) {
            Operation.nextVisit();
            ComputeIntegerValueVisitor fixpointValue = new ComputeIntegerValueVisitor(startValues);
            try {
                for (ParentOutput outputNode : this.graph.getOutput()) {
                    outputNode.postOrderUpwardVisit(fixpointValue);
                }
                this.monteCarloResultsFix.add(fixpointValue.getValues());
            }
            catch (ArithmeticException arithException) {
                System.err.println("div by zero dataset: " + startValues);
                this.monteCarloResultsFloat.remove(i);
                --i;
            }
            ++i;
        }
    }

    private void monteCarloFloat() {
        boolean firstRun = true;
        this.generateMonteCarloInputs();
        for (HashMap<ParentInput, Double> startValues : this.monteCarloInputsFloat) {
            HashMap<Operation, Double> result = this.performMonteCarloIter(startValues);
            this.monteCarloResultsFloat.add(result);
            if (firstRun) {
                HashMap tmp = (HashMap)result.clone();
                tmp.putAll(this.maxValues);
                this.maxValues = tmp;
                tmp = (HashMap)result.clone();
                tmp.putAll(this.minValues);
                this.minValues = tmp;
                firstRun = false;
                continue;
            }
            Util.merge(this.maxValues, result, 2);
            Util.merge(this.minValues, result, 1);
        }
    }

    private void monteCarloErrorAnalysis() {
        HashMap<Operation, Double> maxAbsError = new HashMap<Operation, Double>();
        HashMap<Operation, Double> maxRelError = new HashMap<Operation, Double>();
        Iterator<HashMap<Operation, BigInteger>> iter = this.monteCarloResultsFix.iterator();
        for (HashMap<Operation, Double> floatValues : this.monteCarloResultsFloat) {
            HashMap<Operation, BigInteger> fixValues = iter.next();
            for (Operation op : floatValues.keySet()) {
                FixedPoint fpt = (FixedPoint)op.getType();
                double floatValue = floatValues.get(op);
                double fixValue = Util.floatFromfixedPoint(fixValues.get(op), fpt.getFractionlength());
                double newDifference = Math.abs(floatValue - fixValue);
                if (maxAbsError.containsKey(op) && !((Double)maxAbsError.get(op) < newDifference)) continue;
                maxAbsError.put(op, newDifference);
                maxRelError.put(op, newDifference / floatValue);
            }
        }
        for (Operation op : maxAbsError.keySet()) {
            if (op.getDebugMessage().isEmpty()) continue;
            System.out.println("Difference in node " + op.getDebugMessage() + "=> Abs: " + maxAbsError.get(op) + "   Rel: " + maxRelError.get(op));
        }
    }

    private void traceValues() {
        HashMap<Operation, Double> floatVals = this.monteCarloResultsFloat.get(0);
        for (Operation op : this.monteCarloResultsFix.get(0).keySet()) {
            BigInteger val = this.monteCarloResultsFix.get(0).get(op);
            double doubleval = floatVals.get(op) == null ? 0.0 : floatVals.get(op);
            FixedPoint fp = (FixedPoint)op.getType();
            if (!op.getDebugMessage().isEmpty()) {
                System.out.println(op.getDebugMessage() + " " + op + "    BigIntVal: " + val + " (" + Util.floatFromfixedPoint(val, fp.getFractionlength()) + ")   Float: " + doubleval);
            }
            op.setDebugMessage(op.getDebugMessage() + "\\nBigInteger: " + val + " (" + Util.floatFromfixedPoint(val, fp.getFractionlength()) + ")\\nFloat: " + doubleval + "\\nError: " + Math.abs(doubleval - Util.floatFromfixedPoint(val, fp.getFractionlength())));
        }
    }

    @Override
    public int optimize(Graph graph) {
        boolean changed = false;
        this.graph = graph;
        this.monteCarloFloat();
        Operation.nextVisit();
        ForwardPropagationVisitorNewTypeCast forward = new ForwardPropagationVisitorNewTypeCast(this.minValues, this.maxValues);
        for (ParentOutput parentOutput : graph.getOutput()) {
            parentOutput.postOrderUpwardVisit(forward);
        }
        Operation.nextVisit();
        LimitBitwidthNewTypeCast limit = new LimitBitwidthNewTypeCast(this.opts.getMaxWordlength(), this.opts.getMinFractionlength());
        for (ParentOutput parentOutput : graph.getOutput()) {
            parentOutput.postOrderUpwardVisit(limit);
        }
        System.out.println(limit.getStats());
        Operation.nextVisit();
        ShiftInserterNewTypeCast shiftInserterNewTypeCast = new ShiftInserterNewTypeCast(graph);
        for (ParentOutput outputNode : graph.getOutput()) {
            outputNode.postOrderUpwardVisit(shiftInserterNewTypeCast);
        }
        this.monteCarloFix();
        this.monteCarloErrorAnalysis();
        this.traceValues();
        graph.display((DisplayFactory)new DotDisplayFactory(), "beforetypecast");
        RemoveTypeConversion removeTypeConversion = new RemoveTypeConversion();
        removeTypeConversion.removeTypeConversions(graph);
        return forward.getChanged();
    }

    public String toString() {
        return "Forward Propagation";
    }

    @Override
    public void setOptions(Options opts) {
        this.opts = opts;
    }
}

