/*
 * Decompiled with CFR 0.152.
 */
package wordlengthoptimization;

import datapath.graph.OperationVisitor;
import datapath.graph.operations.Absolut;
import datapath.graph.operations.Add;
import datapath.graph.operations.ArcCos;
import datapath.graph.operations.BinaryOperation;
import datapath.graph.operations.BitwidthTransmogrify;
import datapath.graph.operations.ConstantMultiplication;
import datapath.graph.operations.ConstantOperation;
import datapath.graph.operations.ConstantShift;
import datapath.graph.operations.Cos;
import datapath.graph.operations.Divide;
import datapath.graph.operations.FromOuterLoop;
import datapath.graph.operations.HWInput;
import datapath.graph.operations.HWOutput;
import datapath.graph.operations.Less;
import datapath.graph.operations.Loop;
import datapath.graph.operations.LoopEnd;
import datapath.graph.operations.LoopInit;
import datapath.graph.operations.MemWrite;
import datapath.graph.operations.Multiplication;
import datapath.graph.operations.Mux;
import datapath.graph.operations.Negation;
import datapath.graph.operations.Nop;
import datapath.graph.operations.Operation;
import datapath.graph.operations.Predicate;
import datapath.graph.operations.ShiftMode;
import datapath.graph.operations.Sin;
import datapath.graph.operations.SquareRoot;
import datapath.graph.operations.Subtraction;
import datapath.graph.operations.ToInnerLoop;
import datapath.graph.operations.ToOuterLoop;
import datapath.graph.operations.TopLevelInput;
import datapath.graph.operations.TypeConversion;
import datapath.graph.operations.VariableShift;
import datapath.graph.operations.constValue.FixedPointValue;
import datapath.graph.operations.constValue.FloatValue;
import datapath.graph.type.FixedPoint;
import java.util.HashMap;
import wordlengthoptimization.Util;

public class ForwardPropagationVisitorNewTypeCast
implements OperationVisitor {
    private HashMap<Operation, Double> maxValues = new HashMap();
    private HashMap<Operation, Double> minValues = new HashMap();
    private int changed = 0;

    public ForwardPropagationVisitorNewTypeCast(HashMap<Operation, Double> statisticalMinValue, HashMap<Operation, Double> statisticalMaxvalue) {
        this.maxValues = statisticalMaxvalue;
        this.minValues = statisticalMinValue;
    }

    public void outputStats() {
        System.out.println("MaxValues: \n" + this.maxValues.toString());
        System.out.println("MinValues: \n" + this.minValues.toString());
    }

    public int getChanged() {
        return this.changed;
    }

    private void copyInformation(Operation op) {
        if (op.dependsOnOperations(true).size() != 1) {
            throw new UnsupportedOperationException("More than one predecessor not supported in copyInformation");
        }
        Operation pred = op.dependsOnOperations(true).iterator().next();
        op.setType(pred.getType().clone());
        this.minValues.put(op, this.minValues.get(pred));
        this.maxValues.put(op, this.maxValues.get(pred));
    }

    @Override
    public void visit(ConstantOperation op) {
        double value = 0.0;
        assert (op.getValue() instanceof FloatValue || op.getValue() instanceof FixedPointValue);
        if (op.getValue() instanceof FloatValue) {
            value = ((Float)((FloatValue)op.getValue()).getValue()).floatValue();
        }
        if (op.getValue() instanceof FixedPointValue) {
            value = ((Float)((FixedPointValue)op.getValue()).getValue()).floatValue();
        }
        long frac = Double.doubleToLongBits(value - Math.rint(value)) & 0xFFFFFFFFFFFFFL;
        int prec = Util.bitsRequiredForFraction(op.toString());
        int exp = Math.getExponent(value - Math.rint(value)) + 1023;
        if (exp < 0) {
            prec -= exp;
        }
        op.setType(new FixedPoint(Util.bitsRequired(value, value) + prec, prec, value < 0.0));
    }

    @Override
    public void visit(Add op) {
        double min = this.minValues.get(op);
        double max = this.maxValues.get(op);
        FixedPoint fpl = (FixedPoint)op.getLhs().getType();
        FixedPoint fpr = (FixedPoint)op.getRhs().getType();
        boolean signed = fpl.isSigned() || fpr.isSigned();
        int prec = Math.max(fpl.getFractionlength(), fpr.getFractionlength());
        int intfpl = fpl.getIntBits();
        int intfpr = fpr.getIntBits();
        if (signed) {
            ++intfpl;
            ++intfpr;
        }
        int intbitsize = Math.max(intfpl, Math.max(intfpr, Util.bitsRequired(min, max)));
        op.setType(new FixedPoint(intbitsize + prec + 1, prec, signed));
    }

    @Override
    public void visit(Negation op) {
        Operation pred = op.getData();
        double minValue = -this.maxValues.get(pred).doubleValue();
        double maxValue = -this.minValues.get(pred).doubleValue();
        int prec = ((FixedPoint)pred.getType()).getFractionlength();
        op.setType(new FixedPoint(Util.bitsRequired(minValue, maxValue) + prec, prec, minValue < 0.0));
    }

    @Override
    public void visit(LoopEnd op) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void visit(LoopInit op) {
    }

    @Override
    public void visit(HWOutput op) {
        this.copyInformation(op);
    }

    @Override
    public void visit(TopLevelInput op) {
        if (op.getType() == null) {
            op.setType(new FixedPoint(32, 16, true));
        }
    }

    @Override
    public void visit(Multiplication op) {
        double min = this.minValues.get(op);
        double max = this.maxValues.get(op);
        FixedPoint fpl = (FixedPoint)op.getLhs().getType();
        FixedPoint fpr = (FixedPoint)op.getRhs().getType();
        int prec = fpl.getFractionlength() + fpr.getFractionlength();
        boolean signed = min < 0.0 || fpl.isSigned() || fpr.isSigned();
        int bitsize = Util.bitsRequired(min, max);
        if (min >= 0.0 && signed) {
            ++bitsize;
        }
        op.setType(new FixedPoint(bitsize + prec, prec, signed));
    }

    @Override
    public void visit(Subtraction op) {
        double min = this.minValues.get(op);
        double max = this.maxValues.get(op);
        FixedPoint fpl = (FixedPoint)op.getLhs().getType();
        FixedPoint fpr = (FixedPoint)op.getRhs().getType();
        int prec = Math.max(fpl.getFractionlength(), fpr.getFractionlength());
        int intfpl = fpl.getIntBits() + 1;
        int intfpr = fpr.getIntBits() + 1;
        int intbitsize = Math.max(intfpl, Math.max(intfpr, Util.bitsRequired(min, max)));
        op.setType(new FixedPoint(intbitsize + prec + 1, prec, true));
    }

    @Override
    public void visit(Divide op) {
        double min = this.minValues.get(op);
        double max = this.maxValues.get(op);
        if (op.isNormalization()) {
            min = -1.0;
            max = 1.0;
        }
        FixedPoint fpl = (FixedPoint)op.getLhs().getType();
        FixedPoint fpr = (FixedPoint)op.getRhs().getType();
        int prec = 62;
        int bitsize = Util.bitsRequired(min, max) + 1 + prec;
        boolean signed = true;
        if (signed || !(min < 0.0)) {
            ++bitsize;
        }
        op.setType(new FixedPoint(bitsize, prec, signed));
    }

    @Override
    public void visit(Sin op) {
        double min = -1.0;
        double max = 1.0;
        FixedPoint inputType = (FixedPoint)op.getData().getType();
        op.setType(new FixedPoint(Util.bitsRequired(min, max), inputType.getFractionlength(), true));
    }

    @Override
    public void visit(Cos op) {
        double min = -1.0;
        double max = 1.0;
        FixedPoint inputType = (FixedPoint)op.getData().getType();
        op.setType(new FixedPoint(Util.bitsRequired(min, max), inputType.getFractionlength(), true));
    }

    @Override
    public void visit(Operation op) {
        throw new UnsupportedOperationException("Not supported yet." + op.getClass().toString());
    }

    @Override
    public void visit(BinaryOperation op) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void visit(Mux op) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void visit(ConstantShift op) {
        FixedPoint inputType = (FixedPoint)op.getData().getType();
        FixedPoint resultType = null;
        int totalBitsize = inputType.getBitsize();
        int prec = inputType.getFractionlength();
        switch (op.getMode()) {
            case Left: 
            case LeftRotate: {
                if ((prec -= op.getShiftAmount()) < 0) {
                    totalBitsize += -prec;
                    prec = 0;
                }
                op.setMode(ShiftMode.ZeroShiftLeft);
                break;
            }
            case Right: 
            case SignedRight: 
            case RightRotate: {
                if ((prec += op.getShiftAmount()) > totalBitsize || inputType.isSigned() && prec >= totalBitsize) {
                    totalBitsize = prec;
                    if (inputType.isSigned()) {
                        ++totalBitsize;
                    }
                }
                op.setMode(ShiftMode.ZeroShiftRight);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        resultType = new FixedPoint(totalBitsize, prec, inputType.isSigned());
        op.setType(resultType);
    }

    @Override
    public void visit(Absolut op) {
        double min = 0.0;
        double max = Math.max(Math.abs(this.maxValues.get(op.getData())), Math.abs(this.minValues.get(op.getData())));
        FixedPoint inputType = (FixedPoint)op.getData().getType();
        int prec = inputType.getFractionlength();
        op.setType(new FixedPoint(Util.bitsRequired(min, max) + prec + 1, prec, true));
    }

    @Override
    public void visit(ArcCos op) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void visit(SquareRoot op) {
        double min = 0.0;
        double max = Math.sqrt(this.maxValues.get(op.getData()));
        FixedPoint fp = (FixedPoint)op.getData().getType();
        int prec = Math.min(32, (fp.getFractionlength() + 1) / 2);
        op.setType(new FixedPoint(Util.bitsRequired(min, max) + prec, prec, false));
    }

    @Override
    public void visit(BitwidthTransmogrify op) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void visit(Predicate op) {
    }

    @Override
    public void visit(TypeConversion op) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void visit(MemWrite op) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void visit(Less op) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void visit(FromOuterLoop op) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void visit(ToInnerLoop op) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void visit(HWInput op) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void visit(VariableShift op) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void visit(Loop op) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void visit(Nop op) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void visit(ToOuterLoop op) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void visit(ConstantMultiplication op) {
        this.visit((Multiplication)op);
    }
}

