/*
 * Decompiled with CFR 0.152.
 */
package wordlengthoptimization;

import datapath.graph.OperationVisitor;
import datapath.graph.operations.Absolut;
import datapath.graph.operations.Add;
import datapath.graph.operations.ArcCos;
import datapath.graph.operations.BinaryOperation;
import datapath.graph.operations.BitwidthTransmogrify;
import datapath.graph.operations.ConstantMultiplication;
import datapath.graph.operations.ConstantOperation;
import datapath.graph.operations.ConstantShift;
import datapath.graph.operations.Cos;
import datapath.graph.operations.Divide;
import datapath.graph.operations.FromOuterLoop;
import datapath.graph.operations.HWInput;
import datapath.graph.operations.HWOutput;
import datapath.graph.operations.Less;
import datapath.graph.operations.Loop;
import datapath.graph.operations.LoopEnd;
import datapath.graph.operations.LoopInit;
import datapath.graph.operations.MemWrite;
import datapath.graph.operations.Multiplication;
import datapath.graph.operations.Mux;
import datapath.graph.operations.Negation;
import datapath.graph.operations.Nop;
import datapath.graph.operations.Operation;
import datapath.graph.operations.Predicate;
import datapath.graph.operations.Sin;
import datapath.graph.operations.SquareRoot;
import datapath.graph.operations.Subtraction;
import datapath.graph.operations.ToInnerLoop;
import datapath.graph.operations.ToOuterLoop;
import datapath.graph.operations.TopLevelInput;
import datapath.graph.operations.TypeConversion;
import datapath.graph.operations.VariableShift;
import datapath.graph.type.FixedPoint;
import datapath.graph.type.Type;

public class LimitBitwidth
implements OperationVisitor {
    int maxWordlength;
    int minFractionlength;
    long wordlengthSum;
    long fractionlengthSum;
    long count;
    int wordlengthMax;
    int cutOffs;

    public LimitBitwidth(int maxWordlength, int minFractionlength) {
        this.maxWordlength = maxWordlength;
        this.minFractionlength = minFractionlength;
        this.wordlengthSum = 0L;
        this.fractionlengthSum = 0L;
        this.wordlengthMax = 0;
        this.count = 0L;
        this.cutOffs = 0;
    }

    @Override
    public void visit(Operation op) {
        Type type = op.getType();
        assert (type instanceof FixedPoint);
        FixedPoint fp = (FixedPoint)type;
        if (fp.getFractionlength() < this.minFractionlength) {
            int missing = this.minFractionlength - fp.getFractionlength();
            fp.setBitsize(fp.getBitsize() + missing);
            fp.setFractionlength(this.minFractionlength);
        }
        if (fp.getBitsize() > this.maxWordlength) {
            System.out.println("Wordlength too big, cut off to " + this.maxWordlength + " bits");
            fp.setBitsize(this.maxWordlength);
            ++this.cutOffs;
        }
        this.wordlengthSum += (long)fp.getBitsize();
        this.fractionlengthSum += (long)fp.getFractionlength();
        ++this.count;
        if (fp.getBitsize() > this.wordlengthMax) {
            this.wordlengthMax = fp.getBitsize();
        }
    }

    @Override
    public void visit(BinaryOperation op) {
        this.visit((Operation)op);
    }

    @Override
    public void visit(Mux op) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void visit(ConstantOperation op) {
    }

    @Override
    public void visit(Add op) {
        this.visit((Operation)op);
    }

    @Override
    public void visit(MemWrite op) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void visit(Less op) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void visit(FromOuterLoop op) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void visit(ToInnerLoop op) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void visit(HWInput op) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void visit(VariableShift op) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void visit(Loop op) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void visit(Nop op) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void visit(ToOuterLoop op) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void visit(Negation op) {
        this.visit((Operation)op);
    }

    @Override
    public void visit(LoopEnd op) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void visit(LoopInit op) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void visit(HWOutput op) {
        this.visit((Operation)op);
    }

    @Override
    public void visit(TopLevelInput op) {
    }

    @Override
    public void visit(Multiplication op) {
        this.visit((Operation)op);
    }

    @Override
    public void visit(Subtraction op) {
        this.visit((Operation)op);
    }

    @Override
    public void visit(Divide op) {
        this.visit((Operation)op);
    }

    @Override
    public void visit(Absolut op) {
        this.visit((Operation)op);
    }

    @Override
    public void visit(Sin op) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void visit(Cos op) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void visit(ArcCos op) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void visit(ConstantShift op) {
        this.visit((Operation)op);
    }

    @Override
    public void visit(SquareRoot op) {
        this.visit((Operation)op);
    }

    @Override
    public void visit(BitwidthTransmogrify op) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getStats() {
        return this.count > 0L ? "Average Wordlength: " + this.wordlengthSum / this.count + "  Average Fractionlength: " + this.fractionlengthSum / this.count + "  max. Wordlength: " + this.wordlengthMax + "  performed Cut-Offs: " + this.cutOffs : "No wordlength information available ";
    }

    @Override
    public void visit(Predicate op) {
    }

    @Override
    public void visit(TypeConversion op) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void visit(ConstantMultiplication op) {
        this.visit((Multiplication)op);
    }
}

