/*
 * Decompiled with CFR 0.152.
 */
package wordlengthoptimization;

import datapath.graph.Graph;
import datapath.graph.OperationVisitor;
import datapath.graph.operations.Absolut;
import datapath.graph.operations.Add;
import datapath.graph.operations.ArcCos;
import datapath.graph.operations.BinaryOperation;
import datapath.graph.operations.BitwidthTransmogrify;
import datapath.graph.operations.ConstantMultiplication;
import datapath.graph.operations.ConstantOperation;
import datapath.graph.operations.ConstantShift;
import datapath.graph.operations.Cos;
import datapath.graph.operations.Divide;
import datapath.graph.operations.FromOuterLoop;
import datapath.graph.operations.HWInput;
import datapath.graph.operations.HWOutput;
import datapath.graph.operations.Less;
import datapath.graph.operations.Loop;
import datapath.graph.operations.LoopEnd;
import datapath.graph.operations.LoopInit;
import datapath.graph.operations.MemWrite;
import datapath.graph.operations.Multiplication;
import datapath.graph.operations.Mux;
import datapath.graph.operations.Negation;
import datapath.graph.operations.Nop;
import datapath.graph.operations.Operation;
import datapath.graph.operations.Predicate;
import datapath.graph.operations.ShiftMode;
import datapath.graph.operations.Sin;
import datapath.graph.operations.SquareRoot;
import datapath.graph.operations.Subtraction;
import datapath.graph.operations.ToInnerLoop;
import datapath.graph.operations.ToOuterLoop;
import datapath.graph.operations.TopLevelInput;
import datapath.graph.operations.TypeConversion;
import datapath.graph.operations.UnaryOperation;
import datapath.graph.operations.VariableShift;
import datapath.graph.type.FixedPoint;
import datapath.graph.type.Type;

public class ShiftInserterNewTypeCast
implements OperationVisitor {
    Graph g;

    protected void addToOutput(Operation op, UnaryOperation toInsert) {
        for (Operation ops : op.getUse().toArray(new Operation[0])) {
            ops.replace(op, toInsert);
        }
        toInsert.setData(op);
        this.g.addOperation(toInsert);
        toInsert.setVisited();
    }

    protected void addToInput(Operation op, Operation prev, UnaryOperation toInsert) {
        this.g.insertNode(toInsert, prev, op);
        toInsert.setVisited();
    }

    public ShiftInserterNewTypeCast(Graph g) {
        this.g = g;
    }

    private ConstantShift computeShift(Type before, Type after) {
        if (!(before instanceof FixedPoint) || !(after instanceof FixedPoint)) {
            throw new UnsupportedOperationException("Only Fixed Point Types supported in Word length optimizations / ShiftInserter");
        }
        FixedPoint beforeFp = (FixedPoint)before;
        FixedPoint afterFp = (FixedPoint)after;
        int predDiff = beforeFp.getFractionlength() - afterFp.getFractionlength();
        if (predDiff == 0) {
            return null;
        }
        ConstantShift shifter = predDiff > 0 ? new ConstantShift(predDiff, beforeFp.isSigned() ? ShiftMode.SignedRight : ShiftMode.UnsignedRight) : new ConstantShift(-predDiff, ShiftMode.Left);
        shifter.setVisited();
        return shifter;
    }

    @Override
    public void visit(VariableShift op) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void visit(Negation op) {
        TypeConversion typeCast;
        FixedPoint oldType = (FixedPoint)op.getType();
        if (!oldType.isSigned()) {
            FixedPoint newType = new FixedPoint(oldType.getBitsize() + 1, oldType.getFractionlength(), true);
            typeCast = new TypeConversion(oldType);
            op.setType(newType);
            this.addToOutput(op, typeCast);
            oldType = newType;
        }
        FixedPoint inputType = (FixedPoint)oldType.clone();
        typeCast = new TypeConversion(inputType);
        this.addToInput(op, op.getData(), typeCast);
    }

    @Override
    public void visit(Multiplication op) {
        FixedPoint oldType = (FixedPoint)op.getType();
        FixedPoint fpl = (FixedPoint)op.getLhs().getType();
        FixedPoint fpr = (FixedPoint)op.getRhs().getType();
        if (op.isSigned()) {
            TypeConversion typeCast;
            if (!fpl.isSigned()) {
                fpl = new FixedPoint(fpl.getBitsize() + 1, fpl.getFractionlength(), true);
                typeCast = new TypeConversion(fpl);
                this.addToInput(op, op.getLhs(), typeCast);
            }
            if (!fpr.isSigned()) {
                fpr = new FixedPoint(fpr.getBitsize() + 1, fpr.getFractionlength(), true);
                typeCast = new TypeConversion(fpr);
                this.addToInput(op, op.getRhs(), typeCast);
            }
        }
        int totalBitSize = fpl.getBitsize() + fpr.getBitsize();
        if (op.isSigned()) {
            --totalBitSize;
        }
        FixedPoint newType = new FixedPoint(totalBitSize, fpl.getFractionlength() + fpr.getFractionlength(), oldType.isSigned());
        TypeConversion typeCast = new TypeConversion(oldType);
        op.setType(newType);
        this.addToOutput(op, typeCast);
    }

    @Override
    public void visit(Add op) {
        FixedPoint input = (FixedPoint)op.getType().clone();
        input.setBitsize(input.getBitsize());
        input.setSigned(op.isSigned());
        TypeConversion typeCast = new TypeConversion(input.clone());
        this.addToInput(op, op.getLhs(), typeCast);
        typeCast = new TypeConversion(input.clone());
        this.addToInput(op, op.getRhs(), typeCast);
    }

    @Override
    public void visit(Subtraction op) {
        FixedPoint input = (FixedPoint)op.getType().clone();
        input.setBitsize(input.getBitsize());
        input.setSigned(op.isSigned());
        TypeConversion typeCast = new TypeConversion(input.clone());
        this.addToInput(op, op.getLhs(), typeCast);
        typeCast = new TypeConversion(input.clone());
        this.addToInput(op, op.getRhs(), typeCast);
    }

    private void increaseDivisionPrecision(FixedPoint left, FixedPoint right) {
    }

    @Override
    public void visit(Divide op) {
        FixedPoint fpl = (FixedPoint)op.getLhs().getType().clone();
        FixedPoint fpr = (FixedPoint)op.getRhs().getType().clone();
        FixedPoint oldType = (FixedPoint)op.getType();
        FixedPoint resultType = (FixedPoint)oldType.clone();
        oldType.setBitsize(64);
        oldType.setFractionlength(32);
        fpr.restrictBitwidth(32);
        fpl.setBitsize(32);
        fpr.setBitsize(32);
        fpl.setSigned(true);
        fpr.setSigned(true);
        fpl.setFractionlength(30);
        if (fpl.getFractionlength() > fpr.getFractionlength()) {
            oldType.setFractionlength(32 + (fpl.getFractionlength() - fpr.getFractionlength()));
        } else {
            fpr.setFractionlength(fpl.getFractionlength());
        }
        TypeConversion typeCast = new TypeConversion(fpl);
        this.addToInput(op, op.getLhs(), typeCast);
        typeCast = new TypeConversion(fpr);
        this.addToInput(op, op.getRhs(), typeCast);
        typeCast = new TypeConversion(resultType);
        this.addToOutput(op, typeCast);
    }

    @Override
    public void visit(Operation op) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void visit(BinaryOperation op) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void visit(Mux op) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void visit(ConstantOperation op) {
    }

    @Override
    public void visit(MemWrite op) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void visit(Less op) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void visit(FromOuterLoop op) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void visit(ToInnerLoop op) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void visit(HWInput op) {
    }

    @Override
    public void visit(Loop op) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void visit(Nop op) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void visit(ToOuterLoop op) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void visit(LoopEnd op) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void visit(LoopInit op) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void visit(HWOutput op) {
    }

    @Override
    public void visit(TopLevelInput op) {
    }

    @Override
    public void visit(ConstantShift op) {
        FixedPoint input = (FixedPoint)op.getType().clone();
        FixedPoint prev = (FixedPoint)op.getData().getType();
        input.setFractionlength(prev.getFractionlength());
        if (op.getMode() == ShiftMode.ZeroShiftRight && input.getIntBits() == 0) {
            input.setFractionlength(input.getFractionlength() - op.getShiftAmount());
        }
        TypeConversion typeCast = new TypeConversion(input);
        this.addToInput(op, op.getData(), typeCast);
    }

    @Override
    public void visit(Absolut op) {
        FixedPoint input = (FixedPoint)op.getType().clone();
        input.setSigned(true);
        TypeConversion typeCast = new TypeConversion(input);
        this.addToInput(op, op.getData(), typeCast);
    }

    @Override
    public void visit(Sin op) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void visit(Cos op) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void visit(ArcCos op) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void visit(SquareRoot op) {
        FixedPoint oldType = (FixedPoint)op.getType();
        FixedPoint input = (FixedPoint)op.getData().getType().clone();
        input.setToBitwidth(32);
        if (input.getFractionlength() % 2 == 1) {
            input.setFractionlength(input.getFractionlength() - 1);
        }
        TypeConversion typeCast = new TypeConversion(input);
        this.addToInput(op, op.getData(), typeCast);
        typeCast = new TypeConversion(oldType.clone());
        this.addToOutput(op, typeCast);
        oldType.setFractionlength(input.getFractionlength() / 2);
        oldType.setBitsize(32);
        assert (input.getFractionlength() <= 32);
    }

    @Override
    public void visit(BitwidthTransmogrify op) {
    }

    @Override
    public void visit(Predicate op) {
    }

    @Override
    public void visit(TypeConversion op) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void visit(ConstantMultiplication op) {
        this.visit((Multiplication)op);
    }
}

