/*
 * Decompiled with CFR 0.152.
 */
package wordlengthoptimization;

import datapath.graph.Graph;
import datapath.graph.operations.HWInput;
import datapath.graph.operations.HWOutput;
import datapath.graph.operations.Operation;
import datapath.graph.operations.TopLevelInput;
import java.math.BigInteger;
import java.util.HashMap;

public class Util {
    public static final int MINMERGE = 1;
    public static final int MAXMERGE = 2;

    public static int bitsRequired(double minValue, double maxValue) {
        long absmax = (long)Math.max(Math.abs(minValue), maxValue) + 1L;
        int bits = 64 - Long.numberOfLeadingZeros(absmax);
        if (minValue < 0.0) {
            ++bits;
        }
        return bits;
    }

    public static int bitsRequiredForFraction(String floatnumber) {
        if (floatnumber.contains("eE")) {
            System.out.println("e float represenation not yet supported!");
        }
        int pos = floatnumber.indexOf(".");
        return (int)Math.ceil((double)(floatnumber.length() - pos - 1) * 2.31);
    }

    public static BigInteger fixedPointFromFloat(double d, int prec) {
        return new BigInteger(String.format("%100.0f", d *= Math.pow(2.0, prec)).trim());
    }

    public static double floatFromfixedPoint(BigInteger integer, int prec) {
        return Math.scalb(integer.doubleValue(), -prec);
    }

    public static void fixHWInputs(Graph graph) {
        for (Operation op : graph.getOperations()) {
            if (op instanceof TopLevelInput) {
                TopLevelInput input = (TopLevelInput)op;
                HWInput pred = (HWInput)input.getSource();
                System.out.println("Input: " + input.getName() + " Type: " + input.getType().toString().replace("\n", ", "));
                pred.setType(input.getType().clone());
            }
            if (!(op instanceof HWOutput)) continue;
            HWOutput output = (HWOutput)op;
            System.out.println("Output: " + output.getName() + " Type: " + output.getType().toString().replace("\n", ", "));
        }
    }

    public static void merge(HashMap<Operation, Double> target, HashMap<Operation, Double> additional, int mode) {
        for (Operation op : target.keySet()) {
            double oldTarget = target.get(op);
            double oldAdd = additional.get(op);
            double newVal = 0.0;
            switch (mode) {
                case 1: {
                    newVal = Math.min(oldTarget, oldAdd);
                    break;
                }
                case 2: {
                    newVal = Math.max(oldTarget, oldAdd);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Not supported");
                }
            }
            target.put(op, newVal);
        }
    }
}

