/*
 * Decompiled with CFR 0.152.
 */
package wordlengthoptimization;

import datapath.graph.ModlibWriter;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import wordlengthoptimization.Options;
import wordlengthoptimization.WordlengthOptimization;

public class WordLengthGUI
extends JDialog {
    private Options options;
    private JCheckBox coregenedMults;
    private JButton jButton1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JTextField maxWordlengthField;
    private JTextField minFraclengthField;
    private JTextField monteCarloIters;
    private JComboBox optimizerComboBox;
    private JCheckBox pipelindedMulitplier;

    public WordLengthGUI(Frame parent, boolean modal, Options options) {
        super(parent, modal);
        this.options = options;
        this.initComponents();
    }

    private void initComponents() {
        this.optimizerComboBox = new JComboBox();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.maxWordlengthField = new JTextField();
        this.jLabel3 = new JLabel();
        this.minFraclengthField = new JTextField();
        this.jButton1 = new JButton();
        this.pipelindedMulitplier = new JCheckBox();
        this.jLabel4 = new JLabel();
        this.monteCarloIters = new JTextField();
        this.coregenedMults = new JCheckBox();
        this.setDefaultCloseOperation(2);
        this.setTitle("Wordlength Optimization");
        this.setAlwaysOnTop(true);
        this.setModal(true);
        this.setName("Optimization Parameters");
        this.optimizerComboBox.setModel(new DefaultComboBoxModel<WordlengthOptimization>(this.options.getPossibleOptimizers()));
        this.jLabel1.setText("Optimizer:");
        this.jLabel2.setText("Max. Wordlength:");
        this.maxWordlengthField.setHorizontalAlignment(4);
        this.maxWordlengthField.setText("64");
        this.jLabel3.setText("Min. Fractionlength:");
        this.minFraclengthField.setHorizontalAlignment(4);
        this.minFraclengthField.setText("0");
        this.jButton1.setText("Ready");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WordLengthGUI.this.jButton1ActionPerformed(evt);
            }
        });
        this.pipelindedMulitplier.setText("Pipelined Multiplier");
        this.jLabel4.setText("Monte Carlo Iterations:");
        this.monteCarloIters.setText("100000");
        this.monteCarloIters.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WordLengthGUI.this.monteCarloItersActionPerformed(evt);
            }
        });
        this.coregenedMults.setText("Generate Multiplier");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel4).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButton1).addGroup(layout.createSequentialGroup().addGap(16, 16, 16).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.monteCarloIters, -2, 76, -2).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.minFraclengthField, GroupLayout.Alignment.LEADING).addComponent(this.maxWordlengthField, GroupLayout.Alignment.LEADING, -1, 37, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 62, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.coregenedMults).addComponent(this.pipelindedMulitplier))))))).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 53, Short.MAX_VALUE).addComponent(this.optimizerComboBox, -2, 278, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED))).addGap(20, 20, 20)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(40, 40, 40).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.optimizerComboBox, -2, -1, -2)).addGap(30, 30, 30).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.maxWordlengthField, -2, -1, -2).addComponent(this.pipelindedMulitplier)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.minFraclengthField, -2, -1, -2).addComponent(this.coregenedMults)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.monteCarloIters, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 39, Short.MAX_VALUE).addComponent(this.jButton1).addGap(41, 41, 41)));
        this.pack();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.options.setSelectedOptimizer((WordlengthOptimization)this.optimizerComboBox.getSelectedItem());
        this.options.setMinFractionlength(Integer.parseInt(this.minFraclengthField.getText()));
        this.options.setMaxWordlength(Integer.parseInt(this.maxWordlengthField.getText()));
        this.options.setMonteCarloIterations(Integer.parseInt(this.monteCarloIters.getText()));
        ModlibWriter.mul_pipe = this.pipelindedMulitplier.isSelected();
        ModlibWriter.mul_pipe_create = this.coregenedMults.isSelected();
        this.dispose();
    }

    private void monteCarloItersActionPerformed(ActionEvent evt) {
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                WordLengthGUI dialog = new WordLengthGUI((Frame)new JFrame(), true, null);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

