/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop;

import de.gaalop.AlgebraStrategy;
import de.gaalop.CodeGenerator;
import de.gaalop.CodeParser;
import de.gaalop.CompilationException;
import de.gaalop.GlobalSettingsStrategy;
import de.gaalop.InputFile;
import de.gaalop.OptimizationStrategy;
import de.gaalop.OutputFile;
import de.gaalop.VisualCodeInserterStrategy;
import de.gaalop.cfg.ControlFlowGraph;
import java.util.Observable;
import java.util.Set;

public class CompilerFacade
extends Observable {
    private final CodeParser codeParser;
    private final GlobalSettingsStrategy globalSettingsStrategy;
    private final VisualCodeInserterStrategy visualizerStrategy;
    private final AlgebraStrategy algebraStrategy;
    private final OptimizationStrategy optimizationStrategy;
    private final CodeGenerator codeGenerator;
    private final String algebraName;
    private final boolean asRessource;
    private final String algebraBaseDirectory;

    public CompilerFacade(CodeParser codeParser, GlobalSettingsStrategy globalSettingsStrategy, VisualCodeInserterStrategy visualizerStrategy, AlgebraStrategy algebraStrategy, OptimizationStrategy optimizationStrategy, CodeGenerator codeGenerator, String algebraName, boolean asRessource, String algebraBaseDirectory) {
        this.codeParser = codeParser;
        this.globalSettingsStrategy = globalSettingsStrategy;
        this.visualizerStrategy = visualizerStrategy;
        this.algebraStrategy = algebraStrategy;
        this.optimizationStrategy = optimizationStrategy;
        this.codeGenerator = codeGenerator;
        this.algebraName = algebraName;
        this.asRessource = asRessource;
        this.algebraBaseDirectory = algebraBaseDirectory;
    }

    public Set<OutputFile> compile(InputFile input) throws CompilationException {
        return this.realCompile(input);
    }

    private Set<OutputFile> realCompile(InputFile input) throws CompilationException {
        this.setChanged();
        this.notifyObservers("Parsing...");
        ControlFlowGraph graph = this.codeParser.parseFile(input);
        this.setChanged();
        graph.algebraName = this.algebraName;
        graph.asRessource = this.asRessource;
        graph.algebraBaseDirectory = this.algebraBaseDirectory;
        this.notifyObservers("Setting global settings...");
        this.globalSettingsStrategy.transform(graph);
        this.setChanged();
        this.notifyObservers("Inserting code for visualization...");
        this.visualizerStrategy.transform(graph);
        this.setChanged();
        this.notifyObservers("Algebra inserting...");
        this.algebraStrategy.transform(graph);
        this.setChanged();
        this.notifyObservers("Optimizing...");
        this.optimizationStrategy.transform(graph);
        this.setChanged();
        this.testGraph(graph);
        this.notifyObservers("Generating Code...");
        Set<OutputFile> output = this.codeGenerator.generate(graph);
        this.setChanged();
        this.notifyObservers("Finished");
        return output;
    }

    protected void testGraph(ControlFlowGraph graph) {
    }
}

