/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop;

import de.gaalop.CodeGenerator;
import de.gaalop.CodeGeneratorException;
import de.gaalop.OutputFile;
import de.gaalop.cfg.ControlFlowGraph;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Set;

public abstract class DefaultCodeGenerator
implements CodeGenerator {
    private final String filenameExtension;

    public DefaultCodeGenerator(String filenameExtension) {
        this.filenameExtension = filenameExtension;
    }

    @Override
    public Set<OutputFile> generate(ControlFlowGraph graph) throws CodeGeneratorException {
        String code = this.generateCode(graph);
        String filename = this.generateFilename(graph);
        OutputFile sourceFile = new OutputFile(filename, code, Charset.forName("UTF-8"));
        return Collections.singleton(sourceFile);
    }

    protected String generateFilename(ControlFlowGraph graph) {
        String filename = "gaalop." + this.filenameExtension;
        if (graph.getSource() != null) {
            filename = graph.getSource().getName();
            int lastDotIndex = filename.lastIndexOf(46);
            if (lastDotIndex != -1) {
                filename = filename.substring(0, lastDotIndex);
            }
            filename = filename + "." + this.filenameExtension;
        }
        return filename;
    }

    protected abstract String generateCode(ControlFlowGraph var1);
}

