/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop;

import de.gaalop.OperatorPriority;
import de.gaalop.cfg.BlockEndNode;
import de.gaalop.cfg.BreakNode;
import de.gaalop.cfg.ControlFlowGraph;
import de.gaalop.cfg.ControlFlowVisitor;
import de.gaalop.cfg.EndNode;
import de.gaalop.cfg.IfThenElseNode;
import de.gaalop.cfg.LoopNode;
import de.gaalop.cfg.Macro;
import de.gaalop.dfg.Addition;
import de.gaalop.dfg.BaseVector;
import de.gaalop.dfg.BinaryOperation;
import de.gaalop.dfg.Division;
import de.gaalop.dfg.Equality;
import de.gaalop.dfg.Exponentiation;
import de.gaalop.dfg.Expression;
import de.gaalop.dfg.ExpressionVisitor;
import de.gaalop.dfg.FloatConstant;
import de.gaalop.dfg.FunctionArgument;
import de.gaalop.dfg.Inequality;
import de.gaalop.dfg.InnerProduct;
import de.gaalop.dfg.LogicalAnd;
import de.gaalop.dfg.LogicalNegation;
import de.gaalop.dfg.LogicalOr;
import de.gaalop.dfg.MacroCall;
import de.gaalop.dfg.Multiplication;
import de.gaalop.dfg.OuterProduct;
import de.gaalop.dfg.Relation;
import de.gaalop.dfg.Reverse;
import de.gaalop.dfg.Subtraction;
import java.util.ArrayList;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class DefaultCodeGeneratorVisitor
implements ControlFlowVisitor,
ExpressionVisitor {
    protected Log log = LogFactory.getLog(DefaultCodeGeneratorVisitor.class);
    protected StringBuilder code = new StringBuilder();
    protected ControlFlowGraph graph = null;
    protected OperatorPriority operatorPriority;
    protected int indentation = 0;
    protected Boolean printAddedCode = false;
    protected final String newline = "\n";

    public DefaultCodeGeneratorVisitor() {
        this(new OperatorPriority());
    }

    public DefaultCodeGeneratorVisitor(OperatorPriority operatorPriority) {
        this.operatorPriority = operatorPriority;
    }

    public String getCode() {
        return this.code.toString();
    }

    protected void appendIndentation() {
        for (int i = 0; i < this.indentation; ++i) {
            this.code.append('\t');
        }
    }

    protected void addChild(Expression parent, Expression child) {
        if (this.operatorPriority.hasLowerPriority(parent, child)) {
            this.code.append('(');
            child.accept(this);
            this.code.append(')');
        } else {
            child.accept(this);
        }
    }

    protected void addBinaryInfix(BinaryOperation op, String operator) {
        this.addChild(op, op.getLeft());
        this.code.append(operator);
        this.addChild(op, op.getRight());
    }

    @Override
    public void visit(Addition addition) {
        this.addBinaryInfix(addition, " + ");
    }

    @Override
    public void visit(Subtraction subtraction) {
        this.addBinaryInfix(subtraction, " - ");
    }

    @Override
    public void visit(Multiplication multiplication) {
        this.addBinaryInfix(multiplication, " * ");
    }

    @Override
    public void visit(Division division) {
        this.addBinaryInfix(division, " / ");
    }

    protected boolean isSquare(Exponentiation exponentiation) {
        FloatConstant two = new FloatConstant(2.0);
        return two.equals(exponentiation.getRight());
    }

    @Override
    public void visit(IfThenElseNode node) {
        throw new IllegalStateException("IfThenElseNodes are not supported anymore.");
    }

    @Override
    public void visit(LoopNode node) {
        throw new IllegalStateException("IfThenElseNodes are not supported anymore.");
    }

    @Override
    public void visit(BreakNode breakNode) {
        throw new IllegalStateException("IfThenElseNodes are not supported anymore.");
    }

    @Override
    public void visit(BlockEndNode node) {
        throw new IllegalStateException("IfThenElseNodes are not supported anymore.");
    }

    @Override
    public void visit(InnerProduct innerProduct) {
        throw new UnsupportedOperationException("This backend does not support the inner product.");
    }

    @Override
    public void visit(OuterProduct outerProduct) {
        throw new UnsupportedOperationException("This backend does not support the outer product.");
    }

    @Override
    public void visit(BaseVector baseVector) {
        throw new UnsupportedOperationException("This backend does not support base vectors.");
    }

    @Override
    public void visit(Reverse node) {
        throw new UnsupportedOperationException("This backend does not support the reverse operation.");
    }

    @Override
    public void visit(LogicalOr node) {
        throw new IllegalStateException("Logical nodes are not supported anymore.");
    }

    @Override
    public void visit(LogicalAnd node) {
        throw new IllegalStateException("Logical nodes are not supported anymore.");
    }

    @Override
    public void visit(LogicalNegation node) {
        throw new IllegalStateException("Logical nodes are not supported anymore.");
    }

    @Override
    public void visit(Equality node) {
        throw new IllegalStateException("Logical nodes are not supported anymore.");
    }

    @Override
    public void visit(Inequality node) {
        throw new IllegalStateException("Logical nodes are not supported anymore.");
    }

    @Override
    public void visit(Relation relation) {
        throw new IllegalStateException("Logical nodes are not supported anymore.");
    }

    @Override
    public void visit(Macro node) {
        throw new IllegalStateException("Macros should have been inlined and removed from the graph.");
    }

    @Override
    public void visit(FunctionArgument node) {
        throw new IllegalStateException("Macros should have been inlined and no function arguments should be the graph.");
    }

    @Override
    public void visit(MacroCall node) {
        throw new IllegalStateException("Macro " + node.getName() + " should have been inlined and no macro calls should be in the graph.");
    }

    @Override
    public void visit(EndNode node) {
        for (String text : this.graph.getInsertionTexts()) {
            this.code.insert(0, text + "\n");
        }
    }

    protected void print(Object message) {
        System.out.println(message.toString());
    }

    public void replaceInCode(String target, String replacement) {
        int index = this.code.indexOf(target);
        while (index != -1) {
            this.code.replace(index, index + target.length(), replacement);
            index = this.code.indexOf(target, index + replacement.length());
        }
    }

    protected StringBuilder addCode(char text) {
        return this.addCode(String.valueOf(text));
    }

    protected StringBuilder addLine() {
        return this.addLine("");
    }

    protected StringBuilder addLine(String text) {
        this.appendIndentation();
        return this.addCode(text + "\n");
    }

    protected StringBuilder addCode(String text) {
        if (this.printAddedCode.booleanValue()) {
            StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
            String toPrint = text;
            if (stackTrace.length >= 3) {
                String methodName = stackTrace[2].toString();
                toPrint = toPrint + "                     (" + methodName + ")";
            }
            this.print(toPrint);
        }
        this.code.append(text);
        return this.code;
    }

    protected String JoinString(ArrayList<String> componentVariables, String separator) {
        return componentVariables.stream().collect(Collectors.joining(separator));
    }
}

