/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop;

import de.gaalop.DefaultCodeGeneratorVisitor;
import de.gaalop.StringList;
import de.gaalop.cfg.EndNode;
import de.gaalop.cfg.ReturnDefinition;
import de.gaalop.dfg.Variable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class NonarrayCodeGeneratorVisitor
extends DefaultCodeGeneratorVisitor {
    protected Boolean useArrays = true;
    protected String numberType = "float";
    protected HashSet<String> declaredVariableNames = new HashSet();
    protected Set<String> libraries = new HashSet<String>();

    protected Boolean useNamedTuples() {
        return true;
    }

    @Override
    public void visit(EndNode node) {
        super.visit(node);
        if (!this.useArrays.booleanValue()) {
            StringList gaalopOutputVariables = this.graph.getOutputs();
            ArrayList<String> allBladeVariables = this.getAllBladeVariables(gaalopOutputVariables);
            this.addLine();
            Set<ReturnDefinition> definitions = this.graph.getReturnDefinitions();
            LinkedList<String> returnTypes = new LinkedList<String>();
            ArrayList<String> returnValues = new ArrayList<String>();
            for (String variable : gaalopOutputVariables) {
                String value = this.getReturnValue(allBladeVariables, variable, definitions, returnTypes);
                returnValues.add(value);
            }
            String openingBracket = returnTypes.size() > 1 ? "(" : "";
            String closingBracket = returnTypes.size() > 1 ? ")" : "";
            int size = returnValues.size();
            if (size == 1) {
                this.addLine("return " + openingBracket + String.join((CharSequence)", ", (CharSequence)returnValues.get(0)) + closingBracket + ";");
            } else {
                this.addLine("return " + openingBracket);
                ++this.indentation;
                int i = 0;
                for (String returnValue : returnValues) {
                    this.addLine(returnValue + (++i < size ? ", " : ""));
                }
                --this.indentation;
                this.addLine(closingBracket + ";");
            }
            this.addReturnType(returnTypes);
        }
    }

    protected abstract void addReturnType(List<String> var1);

    private String getReturnValue(ArrayList<String> allBladeVariables, String variable, Set<ReturnDefinition> definitions, List<String> returnTypes) {
        String returnValue;
        List bladeVariables = allBladeVariables.stream().filter(var -> this.GetVariableNameFromBladeVariable((String)var).equals(variable)).collect(Collectors.toList());
        ReturnDefinition matchingDefinition = definitions.stream().filter(definition -> Arrays.stream(definition.variableNames).anyMatch(it -> it.equals(variable))).findFirst().orElse(null);
        if (matchingDefinition != null) {
            returnTypes.add(matchingDefinition.returnType);
            returnValue = matchingDefinition.returnText;
            for (String bladeVariable : bladeVariables) {
                String bladeName = this.GetBladeNameFromBladeVariable(bladeVariable);
                returnValue = returnValue.replace("<" + bladeName + ">", bladeVariable);
            }
        } else {
            if (allBladeVariables.size() == 1) {
                returnTypes.add(this.numberType);
            } else if (this.useNamedTuples().booleanValue()) {
                returnTypes.addAll(bladeVariables.stream().map(var -> this.numberType + " " + var).collect(Collectors.toList()));
            } else {
                returnTypes.addAll(bladeVariables.stream().map(var -> this.numberType).collect(Collectors.toList()));
            }
            returnValue = bladeVariables.stream().collect(Collectors.joining(", "));
        }
        return returnValue;
    }

    private ArrayList<String> getAllBladeVariables(StringList gaalopOutputVariables) {
        ArrayList<String> allBladeVariables = new ArrayList<String>();
        for (String variable : gaalopOutputVariables) {
            for (String componentVariable : this.declaredVariableNames) {
                String variableFromComponent = this.GetVariableNameFromBladeVariable(componentVariable);
                if (!variableFromComponent.equals(variable)) continue;
                allBladeVariables.add(componentVariable);
            }
        }
        return allBladeVariables;
    }

    protected String getNewName(Variable variable) {
        return variable.getNewName(this.graph, this.useArrays);
    }

    protected String GetVariableNameFromBladeVariable(String componentVariable) {
        int index = componentVariable.lastIndexOf("_");
        return componentVariable.substring(0, index);
    }

    protected String GetBladeNameFromBladeVariable(String componentVariable) {
        int index = componentVariable.lastIndexOf("_") + 1;
        return componentVariable.substring(index);
    }
}

