/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop;

import de.gaalop.AlgebraStrategyPlugin;
import de.gaalop.CodeGeneratorPlugin;
import de.gaalop.CodeParserPlugin;
import de.gaalop.GlobalSettingsStrategyPlugin;
import de.gaalop.OptimizationStrategyPlugin;
import de.gaalop.VisualCodeInserterStrategyPlugin;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.ServiceLoader;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class Plugins {
    private static Log log = LogFactory.getLog(Plugins.class);
    private static Set<CodeParserPlugin> codeParserPlugins = Plugins.loadServices(CodeParserPlugin.class);
    private static Set<GlobalSettingsStrategyPlugin> globalSettingsStrategyPlugins = Plugins.loadServices(GlobalSettingsStrategyPlugin.class);
    private static Set<VisualCodeInserterStrategyPlugin> visualizerStrategyPlugins = Plugins.loadServices(VisualCodeInserterStrategyPlugin.class);
    private static Set<AlgebraStrategyPlugin> algebraStrategyPlugins = Plugins.loadServices(AlgebraStrategyPlugin.class);
    private static Set<CodeGeneratorPlugin> codeGeneratorPlugins = Plugins.loadServices(CodeGeneratorPlugin.class);
    private static Set<OptimizationStrategyPlugin> optimizationStrategyPlugins = Plugins.loadServices(OptimizationStrategyPlugin.class);

    private static <T> Set<T> loadServices(Class<T> clazz) {
        HashSet<T> services = new HashSet<T>();
        log.debug((Object)("------------ Loading services of type " + clazz));
        ArrayList names = new ArrayList();
        ServiceLoader<T> loader = ServiceLoader.load(clazz, Plugins.class.getClassLoader());
        for (T service : loader) {
            services.add(service);
            System.out.println("Loaded service : " + service.getClass());
        }
        return services;
    }

    private Plugins() {
    }

    public static Set<CodeParserPlugin> getCodeParserPlugins() {
        return Collections.unmodifiableSet(codeParserPlugins);
    }

    public static Set<GlobalSettingsStrategyPlugin> getGlobalSettingsStrategyPlugins() {
        return Collections.unmodifiableSet(globalSettingsStrategyPlugins);
    }

    public static Set<CodeGeneratorPlugin> getCodeGeneratorPlugins() {
        return Collections.unmodifiableSet(codeGeneratorPlugins);
    }

    public static Set<OptimizationStrategyPlugin> getOptimizationStrategyPlugins() {
        return Collections.unmodifiableSet(optimizationStrategyPlugins);
    }

    public static Set<AlgebraStrategyPlugin> getAlgebraStrategyPlugins() {
        return Collections.unmodifiableSet(algebraStrategyPlugins);
    }

    public static Set<VisualCodeInserterStrategyPlugin> getVisualizerStrategyPlugins() {
        return Collections.unmodifiableSet(visualizerStrategyPlugins);
    }
}

