/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.cfg;

import de.gaalop.cfg.AlgebraSignature;
import de.gaalop.dfg.Expression;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;

public class AlgebraDefinitionFile {
    public String[] base;
    public String lineMapPlusMinusToZeroInf;
    public String[] base2;
    public HashMap<String, Byte> baseSquares = new HashMap();
    public String lineMapZeroInfToPlusMinus;
    public Expression[] blades;
    public Expression[] blades2;
    private boolean usePrecalculatedTable;
    private String productsFilePath;
    private boolean useAsRessource;
    public HashMap<String, Integer> indices = new HashMap();

    public AlgebraSignature getSignature() {
        int p = 0;
        int q = 0;
        int r = 0;
        for (Byte b : this.baseSquares.values()) {
            switch (b) {
                case 1: {
                    ++p;
                    break;
                }
                case -1: {
                    ++q;
                    break;
                }
                case 0: {
                    ++r;
                }
            }
        }
        return new AlgebraSignature(p, q, r);
    }

    public String getBladeString(int index) {
        return this.blades[index].toString();
    }

    public String getBladeStringNormalBase(int index) {
        return this.blades2[index].toString();
    }

    public int getBladeCount() {
        return this.blades.length;
    }

    public Expression getBladeExpression(int index) {
        return this.blades[index];
    }

    public int getIndex(String baseVectorString) {
        return this.getIndexInArray(baseVectorString, this.base);
    }

    private int getIndexInArray(String str, String[] arr) {
        for (int i = 0; i < arr.length; ++i) {
            if (!arr[i].equals(str)) continue;
            return i;
        }
        return -1;
    }

    public boolean isUsePrecalculatedTable() {
        return this.usePrecalculatedTable;
    }

    public void setUsePrecalculatedTable(boolean usePrecalculatedTable) {
        this.usePrecalculatedTable = usePrecalculatedTable;
    }

    public boolean isUseAsRessource() {
        return this.useAsRessource;
    }

    public void setUseAsRessource(boolean useAsRessource) {
        this.useAsRessource = useAsRessource;
    }

    public void loadFromFile(Reader reader) throws IOException {
        BufferedReader d = new BufferedReader(reader);
        this.base = this.parseStrArray(d.readLine());
        this.lineMapPlusMinusToZeroInf = d.readLine();
        this.base2 = this.parseStrArray(d.readLine());
        this.baseSquares = this.parseMapStrByte(d.readLine());
        this.lineMapZeroInfToPlusMinus = d.readLine();
        d.close();
        this.createIndices();
    }

    private String[] parseStrArray(String str) {
        return str.replaceAll(" ", "").split(",");
    }

    private HashMap<String, Byte> parseMapStrByte(String str) {
        String[] parts;
        str = str.replaceAll(" ", "");
        HashMap<String, Byte> result = new HashMap<String, Byte>();
        if (str.isEmpty()) {
            return result;
        }
        for (String part : parts = str.split(",")) {
            String[] parts2 = part.split("=");
            result.put(parts2[0], (byte)Integer.parseInt(parts2[1]));
        }
        return result;
    }

    public void createIndices() {
        int i;
        this.indices.clear();
        for (i = 1; i < this.base.length; ++i) {
            this.indices.put(this.base[i], i);
        }
        for (i = 1; i < this.base2.length; ++i) {
            this.indices.put(this.base2[i], i);
        }
    }

    public String getProductsFilePath() {
        return this.productsFilePath;
    }

    public void setProductsFilePath(String productsFilePath) {
        this.productsFilePath = productsFilePath;
    }
}

