/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.cfg;

import de.gaalop.cfg.ControlFlowGraph;
import de.gaalop.cfg.ControlFlowVisitor;
import de.gaalop.cfg.SequentialNode;
import de.gaalop.dfg.Expression;
import de.gaalop.dfg.Variable;
import de.gaalop.gapp.GAPP;

public final class AssignmentNode
extends SequentialNode {
    private Variable variable;
    private Expression value;
    private GAPP gapp;

    public AssignmentNode(ControlFlowGraph graph, Variable variable, Expression value) {
        super(graph);
        this.variable = variable;
        this.value = value;
    }

    public Variable getVariable() {
        return this.variable;
    }

    public Expression getValue() {
        return this.value;
    }

    public void setVariable(Variable variable) {
        this.variable = variable;
    }

    public void setValue(Expression value) {
        this.value = value;
    }

    @Override
    public void accept(ControlFlowVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void replaceExpression(Expression old, Expression newExpression) {
        if (this.variable == old && newExpression instanceof Variable) {
            this.variable = (Variable)newExpression;
        }
        if (this.value == old) {
            this.value = newExpression;
        } else {
            this.value.replaceExpression(old, newExpression);
        }
    }

    @Override
    public AssignmentNode copyElements() {
        return this.copyElements(this.getGraph());
    }

    @Override
    public AssignmentNode copyElements(ControlFlowGraph graph) {
        AssignmentNode result = new AssignmentNode(graph, this.variable.copy(), this.value.copy());
        result.setGAPP(this.copyGAPP());
        return result;
    }

    public String toString() {
        return this.variable + " := " + this.value;
    }

    protected GAPP copyGAPP() {
        if (this.gapp != null) {
            return this.gapp.getCopy();
        }
        return null;
    }

    public GAPP getGAPP() {
        return this.gapp;
    }

    public void setGAPP(GAPP gapp) {
        this.gapp = gapp;
    }
}

