/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.cfg;

import de.gaalop.cfg.ControlFlowGraph;
import de.gaalop.cfg.ControlFlowVisitor;
import de.gaalop.cfg.SequentialNode;
import de.gaalop.dfg.Expression;
import de.gaalop.dfg.FloatConstant;

public class ColorNode
extends SequentialNode {
    private Expression r;
    private Expression g;
    private Expression b;
    private Expression alpha;

    public ColorNode(ControlFlowGraph graph, Expression r, Expression g, Expression b) {
        super(graph);
        this.r = r;
        this.g = g;
        this.b = b;
        this.alpha = new FloatConstant(1.0);
    }

    public ColorNode(ControlFlowGraph graph, Expression r, Expression g, Expression b, Expression alpha) {
        super(graph);
        this.r = r;
        this.g = g;
        this.b = b;
        this.alpha = alpha;
    }

    public Expression getR() {
        return this.r;
    }

    public Expression getG() {
        return this.g;
    }

    public Expression getB() {
        return this.b;
    }

    public Expression getAlpha() {
        return this.alpha;
    }

    @Override
    public ColorNode copyElements(ControlFlowGraph graph) {
        return new ColorNode(graph, this.r.copy(), this.g.copy(), this.b.copy());
    }

    @Override
    public void accept(ControlFlowVisitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        return "Color(" + this.r + ", " + this.g + ", " + this.b + ", " + this.alpha + ")";
    }

    public void setR(Expression r) {
        this.r = r;
    }

    public void setG(Expression g) {
        this.g = g;
    }

    public void setB(Expression b) {
        this.b = b;
    }

    public void setAlpha(Expression alpha) {
        this.alpha = alpha;
    }
}

