/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.cfg;

import de.gaalop.cfg.BlockEndNode;
import de.gaalop.cfg.ControlFlowGraph;
import de.gaalop.cfg.ControlFlowVisitor;
import de.gaalop.cfg.EndNode;
import de.gaalop.cfg.Node;
import de.gaalop.cfg.SequentialNode;
import de.gaalop.dfg.Expression;
import de.gaalop.dfg.Variable;

public class LoopNode
extends SequentialNode {
    private SequentialNode body;
    private int iterations;
    private Variable counter;

    public LoopNode(ControlFlowGraph graph) {
        super(graph);
    }

    public void setIterations(int iterations) {
        this.iterations = iterations;
    }

    public int getIterations() {
        return this.iterations;
    }

    public void setCounterVariable(Variable counter) {
        this.counter = counter;
    }

    public Variable getCounterVariable() {
        return this.counter;
    }

    public void setBody(SequentialNode body) {
        this.body = body;
    }

    public SequentialNode getBody() {
        return this.body;
    }

    @Override
    public void replaceExpression(Expression old, Expression newExpression) {
        this.replaceSubtree(this.body, old, newExpression);
    }

    private void replaceSubtree(Node root, Expression old, Expression newExpression) {
        if (root instanceof BlockEndNode || root instanceof EndNode) {
            return;
        }
        if (root instanceof SequentialNode) {
            root.replaceExpression(old, newExpression);
            this.replaceSubtree(((SequentialNode)root).getSuccessor(), old, newExpression);
        }
    }

    @Override
    public void replaceSuccessor(Node oldSuccessor, Node newSuccessor) {
        if (oldSuccessor == this.body) {
            newSuccessor.removePredecessor(oldSuccessor);
            newSuccessor.addPredecessor(this);
            this.body = (SequentialNode)newSuccessor;
        } else {
            super.replaceSuccessor(oldSuccessor, newSuccessor);
        }
    }

    @Override
    public void accept(ControlFlowVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public LoopNode copyElements(ControlFlowGraph graph) {
        LoopNode copy = new LoopNode(graph);
        copy.setIterations(this.iterations);
        copy.setCounterVariable(this.counter);
        SequentialNode newBody = this.body.copy();
        newBody.removePredecessor(this);
        newBody.addPredecessor(copy);
        copy.setBody(newBody);
        this.copySubtree(newBody, copy);
        return copy;
    }

    private void copySubtree(SequentialNode root, SequentialNode newBase) {
        if (root instanceof BlockEndNode) {
            ((BlockEndNode)root).updateBase(newBase);
            return;
        }
        if (root.getSuccessor() instanceof SequentialNode) {
            SequentialNode successor = (SequentialNode)root.getSuccessor();
            SequentialNode newSuccessor = successor.copy();
            root.replaceSuccessor(successor, newSuccessor);
            this.copySubtree(newSuccessor, newBase);
        }
    }

    public String toString() {
        return "loop { " + this.body + " ... }";
    }
}

