/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.cfg;

import de.gaalop.cfg.ControlFlowGraph;
import de.gaalop.cfg.ControlFlowVisitor;
import de.gaalop.cfg.SequentialNode;
import de.gaalop.dfg.Expression;
import java.util.ArrayList;
import java.util.List;

public class Macro
extends SequentialNode {
    private String name;
    private List<SequentialNode> body;
    private Expression returnValue;

    public Macro(ControlFlowGraph graph, String name, List<SequentialNode> body, Expression returnValue) {
        super(graph);
        this.name = name;
        this.body = body;
        this.returnValue = returnValue;
    }

    public String getName() {
        return this.name;
    }

    public List<SequentialNode> getBody() {
        return this.body;
    }

    public Expression getReturnValue() {
        return this.returnValue;
    }

    @Override
    public void accept(ControlFlowVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Macro copyElements(ControlFlowGraph graph) {
        ArrayList<SequentialNode> bodyCopy = new ArrayList<SequentialNode>();
        for (SequentialNode node : this.body) {
            bodyCopy.add(node.copy());
        }
        return new Macro(graph, this.name, bodyCopy, this.returnValue.copy());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Macro[");
        sb.append("name=");
        sb.append(this.name);
        sb.append(",body={");
        for (SequentialNode node : this.body) {
            sb.append(node);
            sb.append(";");
        }
        sb.append("}");
        if (this.returnValue != null) {
            sb.append(",returns ");
            sb.append(this.returnValue);
        }
        sb.append("]");
        return sb.toString();
    }
}

