/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.dfg;

import de.gaalop.dfg.Expression;

public abstract class BinaryOperation
extends Expression {
    private Expression left;
    private Expression right;

    public BinaryOperation(Expression left, Expression right) {
        this.left = left;
        this.right = right;
    }

    public Expression getLeft() {
        return this.left;
    }

    public Expression getRight() {
        return this.right;
    }

    @Override
    public void replaceExpression(Expression old, Expression newExpression) {
        if (old == this.left) {
            this.left = newExpression;
        } else if (this.left.isComposite()) {
            this.left.replaceExpression(old, newExpression);
        }
        if (old == this.right) {
            this.right = newExpression;
        } else if (this.right.isComposite()) {
            this.right.replaceExpression(old, newExpression);
        }
    }

    @Override
    public boolean isComposite() {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BinaryOperation that = (BinaryOperation)o;
        if (this.left != null ? !this.left.equals(that.left) : that.left != null) {
            return false;
        }
        return !(this.right != null ? !this.right.equals(that.right) : that.right != null);
    }

    public int hashCode() {
        int result = this.left != null ? this.left.hashCode() : 0;
        result = 31 * result + (this.right != null ? this.right.hashCode() : 0);
        return result;
    }

    public void setLeft(Expression left) {
        this.left = left;
    }

    public void setRight(Expression right) {
        this.right = right;
    }
}

