/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.dfg;

import de.gaalop.dfg.Addition;
import de.gaalop.dfg.BinaryOperation;
import de.gaalop.dfg.Division;
import de.gaalop.dfg.Expression;
import de.gaalop.dfg.LogicalAnd;
import de.gaalop.dfg.LogicalNegation;
import de.gaalop.dfg.Multiplication;
import de.gaalop.dfg.Negation;
import de.gaalop.dfg.OuterProduct;
import de.gaalop.dfg.Subtraction;

public final class ExpressionFactory {
    private ExpressionFactory() {
    }

    public static Addition sum(Expression ... operands) {
        return (Addition)new AdditionCreator().createBinary(operands);
    }

    public static Subtraction subtract(Expression ... operands) {
        return (Subtraction)new SubtractionCreator().createBinary(operands);
    }

    public static Multiplication product(Expression ... factors) {
        return (Multiplication)new MultiplicationCreator().createBinary(factors);
    }

    public static Division divide(Expression ... factors) {
        return (Division)new DivisionCreator().createBinary(factors);
    }

    public static OuterProduct wedge(Expression ... factors) {
        return (OuterProduct)new OuterProductCreator().createBinary(factors);
    }

    public static Multiplication square(Expression base) {
        return new Multiplication(base, base.copy());
    }

    public static Negation negate(Expression value) {
        return new Negation(value.copy());
    }

    public static LogicalAnd and(Expression ... booleanValues) {
        return (LogicalAnd)new LogicalAndCreator().createBinary(booleanValues);
    }

    public static LogicalNegation logicalNegation(Expression expression) {
        return new LogicalNegation(expression);
    }

    private static final class AdditionCreator
    extends BinaryCreator<Addition> {
        private AdditionCreator() {
        }

        @Override
        protected Addition create(Expression left, Expression right) {
            return new Addition(left, right);
        }
    }

    private static final class SubtractionCreator
    extends BinaryCreator<Subtraction> {
        private SubtractionCreator() {
        }

        @Override
        protected Subtraction create(Expression left, Expression right) {
            return new Subtraction(left, right);
        }
    }

    private static final class MultiplicationCreator
    extends BinaryCreator<Multiplication> {
        private MultiplicationCreator() {
        }

        @Override
        protected Multiplication create(Expression left, Expression right) {
            return new Multiplication(left, right);
        }
    }

    private static final class DivisionCreator
    extends BinaryCreator<Division> {
        private DivisionCreator() {
        }

        @Override
        protected Division create(Expression left, Expression right) {
            return new Division(left, right);
        }
    }

    private static final class OuterProductCreator
    extends BinaryCreator<OuterProduct> {
        private OuterProductCreator() {
        }

        @Override
        public OuterProduct create(Expression left, Expression right) {
            return new OuterProduct(left, right);
        }
    }

    private static final class LogicalAndCreator
    extends BinaryCreator<LogicalAnd> {
        private LogicalAndCreator() {
        }

        @Override
        protected LogicalAnd create(Expression left, Expression right) {
            return new LogicalAnd(left, right);
        }
    }

    private static abstract class BinaryCreator<T extends BinaryOperation> {
        private BinaryCreator() {
        }

        protected abstract T create(Expression var1, Expression var2);

        public T createBinary(Expression ... operands) {
            T result;
            if (operands.length < 2) {
                throw new IllegalArgumentException("At least two arguments are required.");
            }
            int i = operands.length - 2;
            Expression lastOperand = operands[operands.length - 1];
            do {
                result = this.create(operands[i], lastOperand);
                lastOperand = result;
            } while (--i >= 0);
            return result;
        }
    }
}

