/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.dfg;

import de.gaalop.dfg.Expression;
import de.gaalop.dfg.ExpressionVisitor;

public final class FloatConstant
extends Expression {
    private final double value;
    private final String valueString;

    public FloatConstant(String value) {
        this.value = Float.parseFloat(value);
        this.valueString = value;
    }

    public FloatConstant(double value) {
        this.value = value;
        this.valueString = null;
    }

    public FloatConstant(double value, String valueStr) {
        this.value = value;
        this.valueString = valueStr;
    }

    @Override
    public Expression copy() {
        return new FloatConstant(this.value, this.valueString);
    }

    @Override
    public boolean isComposite() {
        return false;
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void replaceExpression(Expression old, Expression newExpression) {
    }

    public double getValue() {
        return this.value;
    }

    public String toString() {
        return this.valueString == null ? Double.toString(this.value) : this.valueString;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FloatConstant that = (FloatConstant)o;
        return Double.compare(that.value, this.value) == 0;
    }

    public int hashCode() {
        return this.value != 0.0 ? (int)Double.doubleToLongBits(this.value) : 0;
    }
}

