/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.dfg;

import de.gaalop.dfg.BinaryOperation;
import de.gaalop.dfg.Expression;
import de.gaalop.dfg.ExpressionVisitor;
import de.gaalop.dfg.ToStringUtil;

public final class Relation
extends BinaryOperation {
    private final Type type;

    public Relation(Expression left, Expression right, Type type) {
        super(left, right);
        this.type = type;
    }

    public String toString() {
        return ToStringUtil.bracketComposite(this.getLeft()) + (Object)((Object)this.type) + ToStringUtil.bracketComposite(this.getRight());
    }

    @Override
    public Expression copy() {
        return new Relation(this.getLeft().copy(), this.getRight().copy(), this.type);
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    public String getTypeString() {
        return this.type.toString();
    }

    public Type getType() {
        return this.type;
    }

    public static enum Type {
        LESS{

            public String toString() {
                return " < ";
            }
        }
        ,
        LESS_OR_EQUAL{

            public String toString() {
                return " <= ";
            }
        }
        ,
        GREATER_OR_EQUAL{

            public String toString() {
                return " >= ";
            }
        }
        ,
        GREATER{

            public String toString() {
                return " > ";
            }
        }
        ,
        COEFFICIENT{

            public String toString() {
                return " | ";
            }
        };

    }
}

