/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.dfg;

import de.gaalop.cfg.ControlFlowGraph;
import de.gaalop.dfg.Expression;
import de.gaalop.dfg.ExpressionVisitor;
import de.gaalop.dfg.MultivectorComponent;

public class Variable
extends Expression {
    protected String name;
    protected String minValue = null;
    protected String maxValue = null;
    private boolean global;

    public String getMaxValue() {
        return this.maxValue;
    }

    public String getMinValue() {
        return this.minValue;
    }

    public void setMaxValue(String maxValue) {
        this.maxValue = maxValue;
    }

    public void setMinValue(String minValue) {
        this.minValue = minValue;
    }

    public Variable(String name) {
        if (name.startsWith("::") && name.length() > 2) {
            this.global = true;
            this.name = name.substring(2);
        } else {
            this.name = name;
        }
    }

    public String getNewName(ControlFlowGraph graph, Boolean useArrays) {
        if (this instanceof MultivectorComponent) {
            MultivectorComponent component = (MultivectorComponent)this;
            if (useArrays.booleanValue()) {
                String name = this.getName() + "[" + component.getBladeIndex() + "]";
                String bladeString = graph.getBladeString(component);
                return name;
            }
            String bladeString = graph.getBladeString(component);
            bladeString = bladeString.replace(".0", "");
            String name = this.getName() + "_" + bladeString.replaceAll(" ", "").replaceAll("\\(", "").replaceAll("\\)", "").replaceAll("\\^", "");
            System.out.println(this.getName() + " => " + name);
            return name;
        }
        String name = this.getName();
        return this.getName();
    }

    public boolean globalAccess() {
        return this.global;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public Variable copy() {
        Variable v = new Variable(this.name);
        v.global = this.global;
        v.setMaxValue(this.getMaxValue());
        v.setMinValue(this.getMinValue());
        return v;
    }

    @Override
    public boolean isComposite() {
        return false;
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void replaceExpression(Expression old, Expression newExpression) {
        if (old instanceof Variable && newExpression instanceof Variable) {
            Variable oldVar = (Variable)old;
            Variable newVar = (Variable)newExpression;
            if (oldVar.getName().equals(this.name) && oldVar.getMinValue().equals(this.minValue) && oldVar.getMaxValue().equals(this.maxValue)) {
                this.name = newVar.getName();
                this.minValue = newVar.getMinValue();
                this.maxValue = newVar.getMaxValue();
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Variable variable = (Variable)o;
        return this.name.equals(variable.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public static String removeExtraEs(String input) {
        boolean noEsYet = true;
        StringBuilder output = new StringBuilder();
        for (char c : input.toCharArray()) {
            if (c == 'e') {
                if (!noEsYet) continue;
                output.append(c);
                noEsYet = false;
                continue;
            }
            output.append(c);
        }
        return output.toString();
    }
}

