/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.gapp.executer;

import de.gaalop.gapp.ConstantSetVectorArgument;
import de.gaalop.gapp.PairSetOfVariablesAndIndices;
import de.gaalop.gapp.PosSelector;
import de.gaalop.gapp.PosSelectorset;
import de.gaalop.gapp.Selector;
import de.gaalop.gapp.Selectorset;
import de.gaalop.gapp.SetVectorArgument;
import de.gaalop.gapp.executer.MultivectorWithValues;
import de.gaalop.gapp.instructionSet.GAPPAssignInputsVector;
import de.gaalop.gapp.instructionSet.GAPPAssignMv;
import de.gaalop.gapp.instructionSet.GAPPCalculateMv;
import de.gaalop.gapp.instructionSet.GAPPCalculateMvCoeff;
import de.gaalop.gapp.instructionSet.GAPPDotVectors;
import de.gaalop.gapp.instructionSet.GAPPResetMv;
import de.gaalop.gapp.instructionSet.GAPPSetMv;
import de.gaalop.gapp.instructionSet.GAPPSetVector;
import de.gaalop.gapp.variables.GAPPConstant;
import de.gaalop.gapp.variables.GAPPValueHolder;
import de.gaalop.gapp.variables.GAPPVariable;
import de.gaalop.gapp.variables.GAPPVector;
import de.gaalop.gapp.visitor.CFGGAPPVisitor;
import java.util.Arrays;
import java.util.HashMap;

public class Executer
extends CFGGAPPVisitor {
    private HashMap<String, MultivectorWithValues> values = new HashMap();
    private HashMap<String, Double> inputValues;

    public MultivectorWithValues getValue(String name) {
        return this.values.get(name);
    }

    public HashMap<String, MultivectorWithValues> getValues() {
        return this.values;
    }

    public Executer(HashMap<String, Double> inputValues) {
        this.inputValues = inputValues;
    }

    private MultivectorWithValues getMultivector(String name) {
        if (this.values.containsKey(name)) {
            return this.values.get(name);
        }
        System.err.println("Multivector " + name + " does not exist!");
        return null;
    }

    private void createVector(String name, int size) {
        this.values.put(name, new MultivectorWithValues(size, false));
    }

    private double getVariableValue(String name) {
        return this.inputValues.get(name);
    }

    @Override
    public Object visitResetMv(GAPPResetMv gappResetMv, Object arg) {
        MultivectorWithValues mv = new MultivectorWithValues(gappResetMv.getSize(), true);
        this.values.put(gappResetMv.getDestination().getName(), mv);
        mv.clear();
        return null;
    }

    @Override
    public Object visitSetMv(GAPPSetMv gappSetMv, Object arg) {
        MultivectorWithValues destination = this.getMultivector(gappSetMv.getDestination().getName());
        MultivectorWithValues source = this.getMultivector(gappSetMv.getSource().getName());
        Selectorset selSrc = gappSetMv.getSelectorsSrc();
        PosSelectorset selDest = gappSetMv.getSelectorsDest();
        int selCount = gappSetMv.getSelectorsSrc().size();
        for (int sel = 0; sel < selCount; ++sel) {
            PosSelector sDest = (PosSelector)selDest.get(sel);
            Selector sSrc = (Selector)selSrc.get(sel);
            destination.getEntries()[sDest.getIndex()] = (double)sSrc.getSign() * source.getEntries()[sSrc.getIndex()];
        }
        return null;
    }

    @Override
    public Object visitDotVectors(GAPPDotVectors gappDotVectors, Object arg) {
        MultivectorWithValues destination = this.getMultivector(gappDotVectors.getDestination().getName());
        double sum = 0.0;
        int size = this.getMultivector(gappDotVectors.getParts().getFirst().getName()).getEntries().length;
        for (int slot = 0; slot < size; ++slot) {
            double prod = 1.0;
            for (GAPPVector part : gappDotVectors.getParts()) {
                prod *= this.getMultivector(part.getName()).getEntry(slot);
            }
            sum += prod;
        }
        Selector sDest = gappDotVectors.getDestSelector();
        destination.setEntry(sDest.getIndex(), (double)sDest.getSign() * sum);
        return null;
    }

    @Override
    public Object visitSetVector(GAPPSetVector gappSetVector, Object arg) {
        int size = 0;
        for (SetVectorArgument curArg : gappSetVector.getEntries()) {
            if (curArg.isConstant()) {
                ++size;
                continue;
            }
            PairSetOfVariablesAndIndices p = (PairSetOfVariablesAndIndices)curArg;
            size += p.getSelectors().size();
        }
        String destName = gappSetVector.getDestination().getName();
        this.createVector(destName, size);
        MultivectorWithValues destination = this.getMultivector(destName);
        destination.setEntries(new double[size]);
        int i = 0;
        for (SetVectorArgument curArg : gappSetVector.getEntries()) {
            if (curArg.isConstant()) {
                ConstantSetVectorArgument c = (ConstantSetVectorArgument)curArg;
                destination.setEntry(i, c.getValue());
                ++i;
                continue;
            }
            PairSetOfVariablesAndIndices p = (PairSetOfVariablesAndIndices)curArg;
            MultivectorWithValues source = this.getMultivector(p.getSetOfVariable().getName());
            for (Selector sel : p.getSelectors()) {
                destination.setEntry(i, (double)sel.getSign() * source.getEntries()[sel.getIndex()]);
                ++i;
            }
        }
        return null;
    }

    @Override
    public Object visitAssignMv(GAPPAssignMv gappAssignMv, Object arg) {
        MultivectorWithValues destination = this.getMultivector(gappAssignMv.getDestination().getName());
        PosSelectorset selector = gappAssignMv.getSelectors();
        int selCount = selector.size();
        for (int sel = 0; sel < selCount; ++sel) {
            double value;
            GAPPValueHolder scalarVar = (GAPPValueHolder)gappAssignMv.getValues().get(sel);
            destination.getEntries()[((PosSelector)selector.get((int)sel)).getIndex()] = value = scalarVar.isVariable() ? this.getVariableValue(((GAPPVariable)scalarVar).getName()) : ((GAPPConstant)scalarVar).getValue();
        }
        return null;
    }

    @Override
    public Object visitCalculateMv(GAPPCalculateMv gappCalculate, Object arg) {
        double result;
        MultivectorWithValues mv1 = this.getMultivector(gappCalculate.getOperand1().getName());
        double op1 = mv1.getEntry(0);
        MultivectorWithValues mv2 = null;
        double op2 = 0.0;
        if (gappCalculate.getOperand2() != null) {
            mv2 = this.getMultivector(gappCalculate.getOperand2().getName());
            op2 = mv2.getEntry(0);
        }
        MultivectorWithValues target = this.getMultivector(gappCalculate.getDestination().getName());
        switch (gappCalculate.getType()) {
            case ABS: {
                result = Math.abs(op1);
                break;
            }
            case ACOS: {
                result = Math.acos(op1);
                break;
            }
            case ASIN: {
                result = Math.asin(op1);
                break;
            }
            case ATAN: {
                result = Math.atan(op1);
                break;
            }
            case CEIL: {
                result = Math.ceil(op1);
                break;
            }
            case COS: {
                result = Math.cos(op1);
                break;
            }
            case DIVISION: {
                result = op1 / op2;
                break;
            }
            case EXP: {
                result = Math.exp(op1);
                break;
            }
            case EXPONENTIATION: {
                result = Math.pow(op1, op2);
                break;
            }
            case FACT: {
                result = 1.0;
                for (int i = 2; i <= (int)op1; ++i) {
                    result *= (double)i;
                }
                break;
            }
            case FLOOR: {
                result = Math.floor(op1);
                break;
            }
            case LOG: {
                result = Math.log(op1);
                break;
            }
            case SIN: {
                result = Math.sin(op1);
                break;
            }
            case SQRT: {
                result = Math.sqrt(op1);
                break;
            }
            case TAN: {
                result = Math.tan(op1);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Executer: " + (Object)((Object)gappCalculate.getType()) + " is not supported yet.");
            }
        }
        target.setEntry(0, result);
        return null;
    }

    public void printAllValues() {
        Object[] keys = this.values.keySet().toArray(new String[0]);
        Arrays.sort(keys);
        for (Object m : keys) {
            System.out.println((String)m + " = " + Arrays.toString(this.values.get(m).getEntries()));
        }
    }

    @Override
    public Object visitAssignInputsVector(GAPPAssignInputsVector gappAssignInputsVector, Object arg) {
        int size = gappAssignInputsVector.getValues().size();
        String name = "inputsVector";
        this.createVector(name, size);
        MultivectorWithValues destination = this.getMultivector(name);
        for (int sel = 0; sel < size; ++sel) {
            double value;
            GAPPValueHolder scalarVar = (GAPPValueHolder)gappAssignInputsVector.getValues().get(sel);
            destination.getEntries()[sel] = value = scalarVar.isVariable() ? this.getVariableValue(((GAPPVariable)scalarVar).getName()) : ((GAPPConstant)scalarVar).getValue();
        }
        return null;
    }

    @Override
    public Object visitCalculateMvCoeff(GAPPCalculateMvCoeff gappCalculateCoeff, Object arg) {
        double result;
        MultivectorWithValues mv1 = this.getMultivector(gappCalculateCoeff.getOperand1().getName());
        double op1 = mv1.getEntry(0);
        MultivectorWithValues mv2 = null;
        double op2 = 0.0;
        if (gappCalculateCoeff.getOperand2() != null) {
            mv2 = this.getMultivector(gappCalculateCoeff.getOperand2().getName());
            op2 = mv2.getEntry(0);
        }
        MultivectorWithValues target = this.getMultivector(gappCalculateCoeff.getDestination().getName());
        switch (gappCalculateCoeff.getType()) {
            case ABS: {
                result = Math.abs(op1);
                break;
            }
            case ACOS: {
                result = Math.acos(op1);
                break;
            }
            case ASIN: {
                result = Math.asin(op1);
                break;
            }
            case ATAN: {
                result = Math.atan(op1);
                break;
            }
            case CEIL: {
                result = Math.ceil(op1);
                break;
            }
            case COS: {
                result = Math.cos(op1);
                break;
            }
            case DIVISION: {
                result = op1 / op2;
                break;
            }
            case EXP: {
                result = Math.exp(op1);
                break;
            }
            case EXPONENTIATION: {
                result = Math.pow(op1, op2);
                break;
            }
            case FACT: {
                result = 1.0;
                for (int i = 2; i <= (int)op1; ++i) {
                    result *= (double)i;
                }
                break;
            }
            case FLOOR: {
                result = Math.floor(op1);
                break;
            }
            case LOG: {
                result = Math.log(op1);
                break;
            }
            case SIN: {
                result = Math.sin(op1);
                break;
            }
            case SQRT: {
                result = Math.sqrt(op1);
                break;
            }
            case TAN: {
                result = Math.tan(op1);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Executer: " + (Object)((Object)gappCalculateCoeff.getType()) + " is not supported yet.");
            }
        }
        target.setEntry(gappCalculateCoeff.getDestination().getBladeIndex(), result);
        return null;
    }
}

