/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.gapp.instructionSet;

import de.gaalop.gapp.Selector;
import de.gaalop.gapp.instructionSet.GAPPBaseInstruction;
import de.gaalop.gapp.variables.GAPPMultivector;
import de.gaalop.gapp.variables.GAPPMultivectorComponent;
import de.gaalop.gapp.variables.GAPPVector;
import de.gaalop.gapp.visitor.GAPPVisitor;
import java.util.LinkedList;

public class GAPPDotVectors
extends GAPPBaseInstruction {
    private GAPPMultivector destination;
    private Selector destSelector;
    private LinkedList<GAPPVector> parts;

    public GAPPDotVectors(GAPPMultivector destination, Selector destSelector, LinkedList<GAPPVector> parts) {
        this.destination = destination;
        this.destSelector = destSelector;
        this.parts = parts;
    }

    public GAPPDotVectors(GAPPMultivectorComponent destination, LinkedList<GAPPVector> parts, String bladeName) {
        this.destination = new GAPPMultivector(destination.getName());
        this.destSelector = new Selector(destination.getBladeIndex(), 1, bladeName);
        this.parts = parts;
    }

    @Override
    public Object accept(GAPPVisitor visitor, Object arg) {
        return visitor.visitDotVectors(this, arg);
    }

    public Selector getDestSelector() {
        return this.destSelector;
    }

    public GAPPMultivector getDestination() {
        return this.destination;
    }

    public LinkedList<GAPPVector> getParts() {
        return this.parts;
    }

    public void setDestSelector(Selector destSelector) {
        this.destSelector = destSelector;
    }

    public void setDestination(GAPPMultivector destination) {
        this.destination = destination;
    }

    public void setParts(LinkedList<GAPPVector> parts) {
        this.parts = parts;
    }
}

