/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.visitors;

import de.gaalop.cfg.AssignmentNode;
import de.gaalop.cfg.EmptyControlFlowVisitor;
import de.gaalop.cfg.ExpressionStatement;
import de.gaalop.cfg.StoreResultNode;
import de.gaalop.dfg.Addition;
import de.gaalop.dfg.BaseVector;
import de.gaalop.dfg.Division;
import de.gaalop.dfg.Equality;
import de.gaalop.dfg.Exponentiation;
import de.gaalop.dfg.Expression;
import de.gaalop.dfg.ExpressionVisitor;
import de.gaalop.dfg.FloatConstant;
import de.gaalop.dfg.FunctionArgument;
import de.gaalop.dfg.Inequality;
import de.gaalop.dfg.InnerProduct;
import de.gaalop.dfg.LogicalAnd;
import de.gaalop.dfg.LogicalNegation;
import de.gaalop.dfg.LogicalOr;
import de.gaalop.dfg.MacroCall;
import de.gaalop.dfg.MathFunctionCall;
import de.gaalop.dfg.Multiplication;
import de.gaalop.dfg.MultivectorComponent;
import de.gaalop.dfg.Negation;
import de.gaalop.dfg.OuterProduct;
import de.gaalop.dfg.Relation;
import de.gaalop.dfg.Reverse;
import de.gaalop.dfg.Subtraction;
import de.gaalop.dfg.Variable;
import java.util.HashMap;
import java.util.HashSet;

public class CFGTBAInterpreter
extends EmptyControlFlowVisitor
implements ExpressionVisitor {
    private HashMap<Variable, Double> mapVariables;
    private HashSet<Variable> outputVariables = new HashSet();
    private HashSet<Expression> expressionStatements = new HashSet();
    private double resultValue;

    public CFGTBAInterpreter(HashMap<Variable, Double> inputVariables) {
        this.mapVariables = new HashMap<Variable, Double>(inputVariables);
        this.outputVariables = new HashSet();
    }

    public HashMap<Variable, Double> getMapVariables() {
        return this.mapVariables;
    }

    public HashSet<Variable> getOutputVariables() {
        return this.outputVariables;
    }

    @Override
    public void visit(AssignmentNode node) {
        node.getValue().accept(this);
        this.mapVariables.put(node.getVariable(), this.resultValue);
        super.visit(node);
    }

    @Override
    public void visit(StoreResultNode node) {
        this.outputVariables.add(node.getValue());
        super.visit(node);
    }

    @Override
    public void visit(ExpressionStatement node) {
        this.expressionStatements.add(node.getExpression());
        super.visit(node);
    }

    @Override
    public void visit(Subtraction node) {
        node.getLeft().accept(this);
        double left = this.resultValue;
        node.getRight().accept(this);
        this.resultValue = left - this.resultValue;
    }

    @Override
    public void visit(Addition node) {
        node.getLeft().accept(this);
        double left = this.resultValue;
        node.getRight().accept(this);
        this.resultValue = left + this.resultValue;
    }

    @Override
    public void visit(Division node) {
        node.getLeft().accept(this);
        double left = this.resultValue;
        node.getRight().accept(this);
        this.resultValue = left / this.resultValue;
    }

    @Override
    public void visit(Multiplication node) {
        node.getLeft().accept(this);
        double left = this.resultValue;
        node.getRight().accept(this);
        this.resultValue = left * this.resultValue;
    }

    @Override
    public void visit(MathFunctionCall node) {
        node.getOperand().accept(this);
        switch (node.getFunction()) {
            case ABS: {
                this.resultValue = Math.abs(this.resultValue);
                break;
            }
            case ACOS: {
                this.resultValue = Math.acos(this.resultValue);
                break;
            }
            case ASIN: {
                this.resultValue = Math.asin(this.resultValue);
                break;
            }
            case ATAN: {
                this.resultValue = Math.atan(this.resultValue);
                break;
            }
            case CEIL: {
                this.resultValue = Math.ceil(this.resultValue);
                break;
            }
            case COS: {
                this.resultValue = Math.cos(this.resultValue);
                break;
            }
            case EXP: {
                this.resultValue = Math.exp(this.resultValue);
                break;
            }
            case FACT: {
                int n = (int)Math.floor(this.resultValue);
                this.resultValue = 1.0;
                for (int i = 2; i < n; ++i) {
                    this.resultValue *= (double)i;
                }
                break;
            }
            case FLOOR: {
                this.resultValue = Math.floor(this.resultValue);
                break;
            }
            case INVERT: {
                throw new IllegalStateException("Invert Function is not yet implemented for CFGTBAInterpreter.");
            }
            case LOG: {
                this.resultValue = Math.log(this.resultValue);
                break;
            }
            case SIN: {
                this.resultValue = Math.sin(this.resultValue);
                break;
            }
            case SQRT: {
                this.resultValue = Math.sqrt(this.resultValue);
                break;
            }
            case TAN: {
                this.resultValue = Math.tan(this.resultValue);
            }
        }
    }

    @Override
    public void visit(Variable node) {
        if (!this.mapVariables.containsKey(node)) {
            throw new IllegalStateException("Unknown variable " + node.getName() + ". This variable should be given as an input value.");
        }
        this.resultValue = this.mapVariables.get(node);
    }

    @Override
    public void visit(MultivectorComponent node) {
        this.resultValue = this.mapVariables.get(node);
        if (!this.mapVariables.containsKey(node)) {
            throw new IllegalStateException("Unknown multivector component " + node.toString() + ". This variable should be given as an input value.");
        }
        this.resultValue = this.mapVariables.get(node);
    }

    @Override
    public void visit(Exponentiation node) {
        node.getLeft().accept(this);
        double left = this.resultValue;
        node.getRight().accept(this);
        this.resultValue = Math.pow(left, this.resultValue);
    }

    @Override
    public void visit(FloatConstant node) {
        this.resultValue = node.getValue();
    }

    @Override
    public void visit(Negation node) {
        node.getOperand().accept(this);
        this.resultValue *= -1.0;
    }

    @Override
    public void visit(Reverse node) {
        throw new IllegalStateException("Reverse nodes should have been removed by TBA.");
    }

    @Override
    public void visit(LogicalOr node) {
        throw new IllegalStateException("Logical operations are not implemented in CFGInterpreter.");
    }

    @Override
    public void visit(LogicalAnd node) {
        throw new IllegalStateException("Logical operations are not implemented in CFGInterpreter.");
    }

    @Override
    public void visit(LogicalNegation node) {
        throw new IllegalStateException("Logical operations are not implemented in CFGInterpreter.");
    }

    @Override
    public void visit(Equality node) {
        throw new IllegalStateException("Logical operations are not implemented in CFGInterpreter.");
    }

    @Override
    public void visit(Inequality node) {
        throw new IllegalStateException("Logical operations are not implemented in CFGInterpreter.");
    }

    @Override
    public void visit(Relation relation) {
        throw new IllegalStateException("Logical operations are not implemented in CFGInterpreter.");
    }

    @Override
    public void visit(FunctionArgument node) {
        throw new IllegalStateException("FunctionArgument nodes should have been removed by TBA.");
    }

    @Override
    public void visit(MacroCall node) {
        throw new IllegalStateException("MacroCalls should have been removed by TBA.");
    }

    @Override
    public void visit(InnerProduct node) {
        throw new IllegalStateException("Inner Products should have been removed by TBA.");
    }

    @Override
    public void visit(OuterProduct node) {
        throw new IllegalStateException("OuterProduct nodes should have been removed by TBA.");
    }

    @Override
    public void visit(BaseVector node) {
        throw new IllegalStateException("BaseVector nodes should have been removed by TBA.");
    }
}

