/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.gapp.importing;

import de.gaalop.cfg.AssignmentNode;
import de.gaalop.cfg.ControlFlowGraph;
import de.gaalop.cfg.ControlFlowVisitor;
import de.gaalop.cfg.EmptyControlFlowVisitor;
import de.gaalop.dfg.BinaryOperation;
import de.gaalop.dfg.Division;
import de.gaalop.dfg.Expression;
import de.gaalop.dfg.ExpressionVisitor;
import de.gaalop.dfg.FloatConstant;
import de.gaalop.dfg.Multiplication;
import de.gaalop.dfg.UnaryOperation;
import de.gaalop.visitors.ExpressionTypeVisitor;

public class ConstantDivisionTransformer
extends EmptyControlFlowVisitor {
    private Expression replaceWith = null;
    private ExpressionVisitor expressionVisitor = new ExpressionTypeVisitor(){

        protected void visitBinaryOperation(BinaryOperation node) {
            node.getLeft().accept(ConstantDivisionTransformer.this.expressionVisitor);
            if (ConstantDivisionTransformer.this.replaceWith != null) {
                node.setLeft(ConstantDivisionTransformer.this.replaceWith);
                ConstantDivisionTransformer.this.replaceWith = null;
            }
            node.getRight().accept(ConstantDivisionTransformer.this.expressionVisitor);
            if (ConstantDivisionTransformer.this.replaceWith != null) {
                node.setRight(ConstantDivisionTransformer.this.replaceWith);
                ConstantDivisionTransformer.this.replaceWith = null;
            }
        }

        protected void visitUnaryOperation(UnaryOperation node) {
            node.getOperand().accept(ConstantDivisionTransformer.this.expressionVisitor);
            if (ConstantDivisionTransformer.this.replaceWith != null) {
                node.setOperand(ConstantDivisionTransformer.this.replaceWith);
                ConstantDivisionTransformer.this.replaceWith = null;
            }
        }

        protected void visitTerminal(Expression node) {
        }

        public void visit(Division node) {
            if (node.getRight() instanceof FloatConstant) {
                FloatConstant newLeft = new FloatConstant(1.0 / ((FloatConstant)node.getRight()).getValue());
                ConstantDivisionTransformer.this.replaceWith = (Expression)new Multiplication((Expression)newLeft, node.getLeft());
            }
        }
    };

    private ConstantDivisionTransformer() {
    }

    public static void transform(ControlFlowGraph graph) {
        ConstantDivisionTransformer transformer = new ConstantDivisionTransformer();
        graph.accept((ControlFlowVisitor)transformer);
    }

    public void visit(AssignmentNode node) {
        node.getValue().accept(this.expressionVisitor);
        if (this.replaceWith != null) {
            node.setValue(this.replaceWith);
            this.replaceWith = null;
        }
        super.visit(node);
    }
}

