/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.gapp.importing;

import de.gaalop.gapp.importing.ParallelVector;
import de.gaalop.gapp.importing.parallelObjects.Constant;
import de.gaalop.gapp.importing.parallelObjects.DotProduct;
import de.gaalop.gapp.importing.parallelObjects.MvComponent;
import de.gaalop.gapp.importing.parallelObjects.ParallelObject;
import de.gaalop.gapp.importing.parallelObjects.ParallelObjectType;
import java.util.HashMap;
import java.util.LinkedList;

public class DotProductOptimizer {
    private int height;
    private Constant[] constantsVector = null;
    private HashMap<String, LinkedList<MvComponent[]>> mapVectors = new HashMap();

    public void optimizeOrder(DotProduct dotProduct) {
        DotProduct optimized = new DotProduct();
        this.height = dotProduct.getHeight();
        this.splitToNameVectors(dotProduct);
        if (this.constantsVector != null) {
            optimized.getFactors().add(this.arrToVector(this.constantsVector));
        }
        for (String key : this.mapVectors.keySet()) {
            for (ParallelObject[] parallelObjectArray : this.mapVectors.get(key)) {
                optimized.getFactors().add(this.arrToVector(parallelObjectArray));
            }
        }
        optimized.computeWidthAndHeight();
        dotProduct.setFactors(optimized.getFactors());
        dotProduct.computeWidthAndHeight();
    }

    private void splitToNameVectors(DotProduct dotProduct) {
        for (ParallelVector vector : dotProduct.getFactors()) {
            int row = 0;
            for (ParallelObject object : vector.getSlots()) {
                switch (ParallelObjectType.getType(object)) {
                    case constant: {
                        Constant constant = (Constant)object;
                        if (!(Math.abs(constant.getValue() - 1.0) > 0.001)) break;
                        this.insertConstant(row, constant);
                        break;
                    }
                    case mvComponent: {
                        this.insertMvComponent(row, (MvComponent)object);
                        break;
                    }
                    default: {
                        System.err.println("The type " + ParallelObjectType.getType(object) + " should not appear in a dotProoduct!");
                    }
                }
                ++row;
            }
        }
    }

    private void insertConstant(int row, Constant constant) {
        if (this.constantsVector == null) {
            this.constantsVector = new Constant[this.height];
        }
        if (this.constantsVector[row] == null) {
            this.constantsVector[row] = new Constant(constant.getValue());
        } else {
            this.constantsVector[row].setValue(this.constantsVector[row].getValue() * constant.getValue());
        }
        if (constant.isNegated()) {
            this.constantsVector[row].negate();
        }
    }

    private void insertMvComponent(int row, MvComponent mvComponent) {
        String name = mvComponent.getMultivectorComponent().getName();
        if (!this.mapVectors.containsKey(name)) {
            this.mapVectors.put(name, new LinkedList());
        }
        LinkedList<MvComponent[]> list = this.mapVectors.get(name);
        for (MvComponent[] element : list) {
            if (element[row] != null) continue;
            element[row] = mvComponent;
            return;
        }
        MvComponent[] arr = new MvComponent[this.height];
        arr[row] = mvComponent;
        list.add(arr);
    }

    private ParallelVector arrToVector(ParallelObject[] arr) {
        ParallelVector vector = new ParallelVector();
        for (ParallelObject obj : arr) {
            vector.getSlots().add(obj != null ? obj : new Constant(1.0));
        }
        return vector;
    }
}

