/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.gapp.importing;

import de.gaalop.dfg.Addition;
import de.gaalop.dfg.BaseVector;
import de.gaalop.dfg.BinaryOperation;
import de.gaalop.dfg.Division;
import de.gaalop.dfg.Equality;
import de.gaalop.dfg.Exponentiation;
import de.gaalop.dfg.Expression;
import de.gaalop.dfg.ExpressionVisitor;
import de.gaalop.dfg.FloatConstant;
import de.gaalop.dfg.FunctionArgument;
import de.gaalop.dfg.Inequality;
import de.gaalop.dfg.InnerProduct;
import de.gaalop.dfg.LogicalAnd;
import de.gaalop.dfg.LogicalNegation;
import de.gaalop.dfg.LogicalOr;
import de.gaalop.dfg.MacroCall;
import de.gaalop.dfg.MathFunction;
import de.gaalop.dfg.MathFunctionCall;
import de.gaalop.dfg.Multiplication;
import de.gaalop.dfg.MultivectorComponent;
import de.gaalop.dfg.Negation;
import de.gaalop.dfg.OuterProduct;
import de.gaalop.dfg.Relation;
import de.gaalop.dfg.Reverse;
import de.gaalop.dfg.Subtraction;
import de.gaalop.dfg.UnaryOperation;
import de.gaalop.dfg.Variable;
import de.gaalop.gapp.importing.FactorsGetter;
import de.gaalop.gapp.importing.SignedSummandsGetter;
import de.gaalop.gapp.importing.parallelObjects.Constant;
import de.gaalop.gapp.importing.parallelObjects.ExtCalculation;
import de.gaalop.gapp.importing.parallelObjects.MvComponent;
import de.gaalop.gapp.importing.parallelObjects.ParVariable;
import de.gaalop.gapp.importing.parallelObjects.ParallelObject;
import de.gaalop.gapp.instructionSet.CalculationType;

public class ExpressionCollector
implements ExpressionVisitor {
    private ParallelObject resultValue;

    public ParallelObject getResultValue() {
        return this.resultValue;
    }

    public void visit(Subtraction node) {
        this.resultValue = SignedSummandsGetter.getSignedSummands((Expression)node);
    }

    public void visit(Addition node) {
        this.resultValue = SignedSummandsGetter.getSignedSummands((Expression)node);
    }

    public void visit(Multiplication node) {
        this.resultValue = FactorsGetter.getFactors((Expression)node);
    }

    public void visit(FloatConstant node) {
        this.resultValue = new Constant(node.getValue());
    }

    public void visit(MultivectorComponent node) {
        this.resultValue = new MvComponent(node);
    }

    public void visit(Division node) {
        this.createExtCalculationFromBinaryOperation((BinaryOperation)node, CalculationType.DIVISION);
    }

    private CalculationType transformFunction(MathFunction function) {
        switch (function) {
            case ABS: {
                return CalculationType.ABS;
            }
            case ACOS: {
                return CalculationType.ACOS;
            }
            case ASIN: {
                return CalculationType.ASIN;
            }
            case ATAN: {
                return CalculationType.ATAN;
            }
            case CEIL: {
                return CalculationType.CEIL;
            }
            case COS: {
                return CalculationType.COS;
            }
            case EXP: {
                return CalculationType.EXP;
            }
            case FACT: {
                return CalculationType.FACT;
            }
            case FLOOR: {
                return CalculationType.FLOOR;
            }
            case LOG: {
                return CalculationType.LOG;
            }
            case SIN: {
                return CalculationType.SIN;
            }
            case SQRT: {
                return CalculationType.SQRT;
            }
            case TAN: {
                return CalculationType.TAN;
            }
            case INVERT: {
                return CalculationType.INVERT;
            }
        }
        System.err.println("Unknown MathFunction: " + function);
        return null;
    }

    public void visit(MathFunctionCall node) {
        this.createExtCalculationFromUnaryOperation((UnaryOperation)node, this.transformFunction(node.getFunction()));
    }

    public void visit(Exponentiation node) {
        this.createExtCalculationFromBinaryOperation((BinaryOperation)node, CalculationType.EXPONENTIATION);
    }

    public void visit(Negation node) {
        this.resultValue = null;
        node.getOperand().accept((ExpressionVisitor)this);
        this.resultValue.negate();
    }

    private void createExtCalculationFromUnaryOperation(UnaryOperation node, CalculationType type) {
        this.resultValue = null;
        node.getOperand().accept((ExpressionVisitor)this);
        this.resultValue = new ExtCalculation(type, this.resultValue, null);
    }

    private void createExtCalculationFromBinaryOperation(BinaryOperation node, CalculationType type) {
        this.resultValue = null;
        node.getLeft().accept((ExpressionVisitor)this);
        ParallelObject left = this.resultValue;
        this.resultValue = null;
        node.getRight().accept((ExpressionVisitor)this);
        ParallelObject right = this.resultValue;
        this.resultValue = new ExtCalculation(type, left, right);
    }

    public void visit(Variable node) {
        this.resultValue = new ParVariable(node.getName());
    }

    public void visit(LogicalOr node) {
        throw new IllegalStateException("Logical functions are not allowed.");
    }

    public void visit(LogicalAnd node) {
        throw new IllegalStateException("Logical functions are not allowed.");
    }

    public void visit(LogicalNegation node) {
        throw new IllegalStateException("Logical functions are not allowed.");
    }

    public void visit(Equality node) {
        throw new IllegalStateException("Logical functions are not allowed.");
    }

    public void visit(Inequality node) {
        throw new IllegalStateException("Logical functions are not allowed.");
    }

    public void visit(Relation relation) {
        throw new IllegalStateException("Logical functions are not allowed.");
    }

    public void visit(InnerProduct node) {
        throw new IllegalStateException("InnerProducts should have been removed by TBA.");
    }

    public void visit(OuterProduct node) {
        throw new IllegalStateException("OuterProducts should have been removed by TBA.");
    }

    public void visit(BaseVector node) {
        throw new IllegalStateException("BaseVectors should have been removed by TBA.");
    }

    public void visit(Reverse node) {
        throw new IllegalStateException("Reverses should have been removed by TBA.");
    }

    public void visit(FunctionArgument node) {
        throw new IllegalStateException("FunctionArguments should have been removed by CLUCalc Parser.");
    }

    public void visit(MacroCall node) {
        throw new IllegalStateException("FunctionArguments should have been removed by CLUCalc Parser.");
    }
}

