/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.gapp.importing;

import de.gaalop.dfg.MultivectorComponent;
import de.gaalop.gapp.ConstantSetVectorArgument;
import de.gaalop.gapp.GAPP;
import de.gaalop.gapp.PairSetOfVariablesAndIndices;
import de.gaalop.gapp.PosSelector;
import de.gaalop.gapp.PosSelectorset;
import de.gaalop.gapp.Selector;
import de.gaalop.gapp.Selectorset;
import de.gaalop.gapp.Valueset;
import de.gaalop.gapp.importing.GAPPMultivectorCreator;
import de.gaalop.gapp.importing.ParallelVector;
import de.gaalop.gapp.importing.parallelObjects.Constant;
import de.gaalop.gapp.importing.parallelObjects.DotProduct;
import de.gaalop.gapp.importing.parallelObjects.ExtCalculation;
import de.gaalop.gapp.importing.parallelObjects.MvComponent;
import de.gaalop.gapp.importing.parallelObjects.ParVariable;
import de.gaalop.gapp.importing.parallelObjects.ParallelObject;
import de.gaalop.gapp.importing.parallelObjects.ParallelObjectType;
import de.gaalop.gapp.importing.parallelObjects.ParallelObjectVisitor;
import de.gaalop.gapp.importing.parallelObjects.Product;
import de.gaalop.gapp.importing.parallelObjects.Sum;
import de.gaalop.gapp.instructionSet.GAPPAssignMv;
import de.gaalop.gapp.instructionSet.GAPPBaseInstruction;
import de.gaalop.gapp.instructionSet.GAPPCalculateMvCoeff;
import de.gaalop.gapp.instructionSet.GAPPDotVectors;
import de.gaalop.gapp.instructionSet.GAPPResetMv;
import de.gaalop.gapp.instructionSet.GAPPSetMv;
import de.gaalop.gapp.instructionSet.GAPPSetVector;
import de.gaalop.gapp.variables.GAPPConstant;
import de.gaalop.gapp.variables.GAPPMultivector;
import de.gaalop.gapp.variables.GAPPMultivectorComponent;
import de.gaalop.gapp.variables.GAPPSetOfVariables;
import de.gaalop.gapp.variables.GAPPVector;
import de.gaalop.tba.Algebra;
import java.util.HashSet;
import java.util.LinkedList;

public class GAPPCreator
implements ParallelObjectVisitor {
    private static final boolean USE_DOTPRODUCT_OPTIMIZER = false;
    public GAPP gapp;
    private int curTmp = -1;
    private final String PREFIX_VE = "ve";
    private final String PREFIX_TMPMV = "tempmv";
    private HashSet<String> variables;
    private int bladeCount;
    private Algebra algebra;

    public GAPPCreator(HashSet<String> variables, int bladeCount, Algebra algebra) {
        this.variables = variables;
        this.bladeCount = bladeCount;
        this.algebra = algebra;
    }

    public void setGapp(GAPP gapp) {
        this.gapp = gapp;
    }

    private String createTMP(String prefix) {
        ++this.curTmp;
        while (this.variables.contains(prefix + this.curTmp)) {
            ++this.curTmp;
        }
        return prefix + this.curTmp;
    }

    public GAPPMultivector createMv() {
        GAPPMultivector mv = new GAPPMultivector(this.createTMP("tempmv"));
        this.gapp.addInstruction((GAPPBaseInstruction)new GAPPResetMv(mv, 1));
        return mv;
    }

    public GAPPMultivectorComponent createMvComp() {
        GAPPMultivector mv = new GAPPMultivector(this.createTMP("tempmv"));
        this.gapp.addInstruction((GAPPBaseInstruction)new GAPPResetMv(mv, 1));
        return new GAPPMultivectorComponent(mv.getName(), 0);
    }

    private GAPPVector createVe() {
        return new GAPPVector(this.createTMP("ve"));
    }

    @Override
    public Object visitProduct(Product product, Object arg) {
        DotProduct dp = new DotProduct();
        dp.setNegated(product.isNegated());
        int factorNo = 0;
        for (ParallelObject obj : product.getFactors()) {
            dp.set(0, factorNo, obj);
            ++factorNo;
        }
        return dp.accept(this, arg);
    }

    @Override
    public Object visitVariable(ParVariable variable, Object arg) {
        throw new IllegalStateException("Variable should not appear in GAPPCreator!");
    }

    @Override
    public Object visitExtCalculation(ExtCalculation extCalculation, Object arg) {
        GAPPMultivectorComponent destination;
        GAPPMultivectorComponent altDestination = destination = (GAPPMultivectorComponent)arg;
        if (extCalculation.isNegated()) {
            destination = this.createMvComp();
        }
        if (!extCalculation.getOperand1().isTerminal()) {
            GAPPMultivector mvTmp1 = this.createMv();
            GAPPMultivectorComponent gMvC1 = new GAPPMultivectorComponent(mvTmp1.getName(), 0);
            extCalculation.getOperand1().accept(this, gMvC1);
            extCalculation.setOperand1(new MvComponent(new MultivectorComponent(mvTmp1.getName(), 0)));
        }
        if (extCalculation.getOperand2() != null && !extCalculation.getOperand2().isTerminal()) {
            GAPPMultivector mvTmp2 = this.createMv();
            GAPPMultivectorComponent gMvC2 = new GAPPMultivectorComponent(mvTmp2.getName(), 0);
            extCalculation.getOperand2().accept(this, gMvC2);
            extCalculation.setOperand2(new MvComponent(new MultivectorComponent(mvTmp2.getName(), 0)));
        }
        this.gapp.addInstruction((GAPPBaseInstruction)new GAPPCalculateMvCoeff(extCalculation.getType(), destination, this.createMultivectorFromParallelObjectTerminal(extCalculation.getOperand1()), extCalculation.getOperand2() == null ? null : this.createMultivectorFromParallelObjectTerminal(extCalculation.getOperand2())));
        if (extCalculation.isNegated()) {
            PosSelectorset selDest = new PosSelectorset();
            selDest.add((Object)new PosSelector(altDestination.getBladeIndex(), this.algebra.getBlade(altDestination.getBladeIndex()).toString()));
            Selectorset selSrc = new Selectorset();
            selSrc.add((Object)new Selector(destination.getBladeIndex(), -1, this.algebra.getBlade(destination.getBladeIndex()).toString()));
            GAPPSetMv setMv = new GAPPSetMv(new GAPPMultivector(altDestination.getName()), (GAPPSetOfVariables)new GAPPMultivector(destination.getName()), selDest, selSrc);
            this.gapp.addInstruction((GAPPBaseInstruction)setMv);
        }
        return null;
    }

    private GAPPMultivector createMultivectorFromParallelObjectTerminal(ParallelObject object) {
        GAPPMultivectorCreator creator = new GAPPMultivectorCreator(this, this.bladeCount, this.algebra);
        return (GAPPMultivector)object.accept(creator, null);
    }

    @Override
    public Object visitConstant(Constant constant, Object arg) {
        GAPPMultivectorComponent destination = (GAPPMultivectorComponent)arg;
        PosSelectorset selSet = new PosSelectorset();
        selSet.add((Object)new PosSelector(destination.getBladeIndex(), this.algebra.getBlade(destination.getBladeIndex()).toString()));
        Valueset valSet = new Valueset();
        valSet.add((Object)new GAPPConstant((double)(constant.isNegated() ? -1 : 1) * constant.getValue()));
        this.gapp.addInstruction((GAPPBaseInstruction)new GAPPAssignMv(new GAPPMultivector(destination.getName()), selSet, valSet));
        return null;
    }

    @Override
    public Object visitMvComponent(MvComponent mvComponent, Object arg) {
        GAPPMultivectorComponent destination = (GAPPMultivectorComponent)arg;
        PosSelectorset selDestSet = new PosSelectorset();
        selDestSet.add((Object)new PosSelector(destination.getBladeIndex(), this.algebra.getBlade(destination.getBladeIndex()).toString()));
        Selectorset selSrcSet = new Selectorset();
        selSrcSet.add((Object)new Selector(mvComponent.getMultivectorComponent().getBladeIndex(), mvComponent.isNegated() ? (byte)-1 : 1, this.algebra.getBlade(mvComponent.getMultivectorComponent().getBladeIndex()).toString()));
        this.gapp.addInstruction((GAPPBaseInstruction)new GAPPSetMv(new GAPPMultivector(destination.getName()), (GAPPSetOfVariables)new GAPPMultivector(mvComponent.getMultivectorComponent().getName()), selDestSet, selSrcSet));
        return null;
    }

    @Override
    public Object visitDotProduct(DotProduct dotProduct, Object arg) {
        GAPPMultivectorComponent destination;
        for (int row = 0; row < dotProduct.getHeight(); ++row) {
            for (int col = 0; col < dotProduct.getWidth(); ++col) {
                if (dotProduct.get(row, col).isTerminal()) continue;
                ParallelObject nonTerminalObj = dotProduct.get(row, col);
                GAPPMultivector mvTmp = this.createMv();
                GAPPMultivectorComponent gMvC = new GAPPMultivectorComponent(mvTmp.getName(), 0);
                nonTerminalObj.accept(this, gMvC);
                dotProduct.set(row, col, new MvComponent(new MultivectorComponent(mvTmp.getName(), 0)));
            }
        }
        GAPPMultivectorComponent altDestination = destination = arg == null ? this.createMvComp() : (GAPPMultivectorComponent)arg;
        if (dotProduct.isNegated()) {
            destination = this.createMvComp();
        }
        LinkedList<GAPPVector> parts = new LinkedList<GAPPVector>();
        GAPPDotVectors dotVectors = new GAPPDotVectors(destination, parts, this.algebra.getBlade(destination.getBladeIndex()).toString());
        for (ParallelVector vector : dotProduct.getFactors()) {
            parts.add(this.createVectorFromParallelVector(vector));
        }
        this.gapp.addInstruction((GAPPBaseInstruction)dotVectors);
        if (dotProduct.isNegated()) {
            PosSelectorset selDest = new PosSelectorset();
            selDest.add((Object)new PosSelector(altDestination.getBladeIndex(), this.algebra.getBlade(altDestination.getBladeIndex()).toString()));
            Selectorset selSrc = new Selectorset();
            selSrc.add((Object)new Selector(destination.getBladeIndex(), -1, this.algebra.getBlade(destination.getBladeIndex()).toString()));
            GAPPSetMv setMv = new GAPPSetMv(new GAPPMultivector(altDestination.getName()), (GAPPSetOfVariables)new GAPPMultivector(destination.getName()), selDest, selSrc);
            this.gapp.addInstruction((GAPPBaseInstruction)setMv);
        }
        return arg == null ? destination : null;
    }

    private GAPPVector createVectorFromParallelVector(ParallelVector vector) {
        GAPPVector destination = this.createVe();
        LinkedList<ConstantSetVectorArgument> list = new LinkedList<ConstantSetVectorArgument>();
        ConstantSetVectorArgument last = null;
        for (ParallelObject object : vector.getSlots()) {
            switch (ParallelObjectType.getType(object)) {
                case constant: {
                    last = new ConstantSetVectorArgument((double)(object.isNegated() ? -1 : 1) * ((Constant)object).getValue());
                    list.add(last);
                    break;
                }
                case mvComponent: {
                    MultivectorComponent mvC = ((MvComponent)object).getMultivectorComponent();
                    Selector sel = new Selector(mvC.getBladeIndex(), object.isNegated() ? (byte)-1 : 1, this.algebra.getBlade(mvC.getBladeIndex()).toString());
                    if (last != null && !last.isConstant()) {
                        PairSetOfVariablesAndIndices pair = (PairSetOfVariablesAndIndices)last;
                        if (pair.getSetOfVariable().getName().equals(mvC.getName())) {
                            pair.getSelectors().add((Object)sel);
                            break;
                        }
                        Selectorset selSet = new Selectorset();
                        selSet.add((Object)sel);
                        last = new PairSetOfVariablesAndIndices((GAPPSetOfVariables)new GAPPMultivector(mvC.getName()), selSet);
                        list.add(last);
                        break;
                    }
                    Selectorset selSet = new Selectorset();
                    selSet.add((Object)sel);
                    last = new PairSetOfVariablesAndIndices((GAPPSetOfVariables)new GAPPMultivector(mvC.getName()), selSet);
                    list.add(last);
                    break;
                }
                default: {
                    System.err.println("createVectorFromParallelVector for " + ParallelObjectType.getType(object) + " is not implemented!");
                }
            }
        }
        this.gapp.addInstruction((GAPPBaseInstruction)new GAPPSetVector(destination, list));
        return destination;
    }

    @Override
    public Object visitSum(Sum sum, Object arg) {
        throw new IllegalStateException("Sums should have been removed by DotProductCreator&Finder");
    }
}

