/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.gapp.importing;

import de.gaalop.OptimizationException;
import de.gaalop.cfg.AssignmentNode;
import de.gaalop.cfg.ControlFlowGraph;
import de.gaalop.cfg.ControlFlowVisitor;
import de.gaalop.cfg.EmptyControlFlowVisitor;
import de.gaalop.cfg.StoreResultNode;
import de.gaalop.dfg.EmptyExpressionVisitor;
import de.gaalop.dfg.ExpressionVisitor;
import de.gaalop.dfg.MultivectorComponent;
import de.gaalop.dfg.Variable;
import de.gaalop.gapp.GAPP;
import de.gaalop.gapp.Plugin;
import de.gaalop.gapp.Variableset;
import de.gaalop.gapp.importing.ConstantDivisionTransformer;
import de.gaalop.gapp.importing.GAPPDecorator;
import de.gaalop.gapp.importing.ReplaceVisitor;
import de.gaalop.gapp.importing.optimization.GAPPFurtherOptimizationsFacade;
import de.gaalop.gapp.instructionSet.GAPPAssignInputsVector;
import de.gaalop.gapp.instructionSet.GAPPBaseInstruction;
import de.gaalop.gapp.variables.GAPPScalarVariable;
import de.gaalop.gapp.variables.GAPPVector;
import de.gaalop.tba.cfgImport.CFGImporterFacade;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;

public class GAPPDecoratingMain {
    private Plugin plugin;

    public GAPPDecoratingMain(Plugin plugin) {
        this.plugin = plugin;
    }

    public ControlFlowGraph decorateGraph(ControlFlowGraph graph) throws OptimizationException {
        Variable inputsVectorVar = new Variable("inputsVector");
        if (graph.getInputVariables().contains(inputsVectorVar) || graph.getScalarVariables().contains(inputsVectorVar) || graph.getLocalVariables().contains(inputsVectorVar)) {
            throw new OptimizationException("The usage of 'inputsVector' as a variable is not allowed with using the GAPP optimization!\nPlease rename the 'inputsVector' variable definition and usages!", graph);
        }
        boolean scalarFunctions = this.plugin.isUseScalarFunctions();
        de.gaalop.tba.Plugin plugin = new de.gaalop.tba.Plugin();
        plugin.setInvertTransformation(true);
        plugin.setScalarFunctions(scalarFunctions);
        plugin.setOptInserting(graph.globalSettings.isOptMaxima());
        plugin.setMaximaExpand(this.plugin.isMaximaExpand());
        plugin.setOptGCSE(graph.globalSettings.isOptMaxima());
        plugin.createVariablesInGCSE = false;
        CFGImporterFacade facade = new CFGImporterFacade(plugin);
        facade.importGraph(graph);
        ConstantDivisionTransformer.transform(graph);
        GAPP gappStart = new GAPP();
        HashSet<String> variables = this.getAllVariableNames(graph);
        this.assignInputVariables(graph, gappStart);
        GAPPDecorator vCFG = new GAPPDecorator(gappStart, variables, facade.getUsedAlgebra().getBladeCount(), scalarFunctions, facade.getUsedAlgebra().getAlgebra());
        graph.accept((ControlFlowVisitor)vCFG);
        GAPPFurtherOptimizationsFacade furtherOpt = new GAPPFurtherOptimizationsFacade();
        furtherOpt.doFurtherGAPPOptimizations(graph);
        return graph;
    }

    private void assignInputVariables(ControlFlowGraph graph, GAPP gappStart) {
        if (graph.getInputVariables().isEmpty()) {
            return;
        }
        LinkedList toDo = new LinkedList(graph.getInputVariables());
        Collections.sort(toDo, new Comparator<Variable>(){

            @Override
            public int compare(Variable o1, Variable o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        HashMap<Variable, MultivectorComponent> map = new HashMap<Variable, MultivectorComponent>();
        GAPPVector inputsMv = new GAPPVector("inputsVector");
        Variableset varSet = new Variableset();
        int slotNo = 0;
        for (Variable var : toDo) {
            varSet.add((Object)new GAPPScalarVariable(var.getName()));
            map.put(var, new MultivectorComponent(inputsMv.getName(), slotNo));
            ++slotNo;
        }
        gappStart.addInstruction((GAPPBaseInstruction)new GAPPAssignInputsVector(varSet));
        while (!toDo.isEmpty()) {
            Variable curVar = (Variable)toDo.removeFirst();
            ReplaceVisitor replaceVisitor = new ReplaceVisitor(curVar, (MultivectorComponent)map.get(curVar));
            graph.accept((ControlFlowVisitor)replaceVisitor);
        }
    }

    private HashSet<String> getAllVariableNames(ControlFlowGraph graph) {
        final HashSet<String> result = new HashSet<String>();
        EmptyControlFlowVisitor visitor = new EmptyControlFlowVisitor(){
            private ExpressionVisitor visitorExp = new EmptyExpressionVisitor(){

                public void visit(MultivectorComponent node) {
                    result.add(node.getName());
                    super.visit(node);
                }

                public void visit(Variable node) {
                    result.add(node.getName());
                    super.visit(node);
                }
            };

            public void visit(AssignmentNode node) {
                node.getVariable().accept(this.visitorExp);
                node.getValue().accept(this.visitorExp);
                super.visit(node);
            }

            public void visit(StoreResultNode node) {
                node.getValue().accept(this.visitorExp);
                super.visit(node);
            }
        };
        graph.accept((ControlFlowVisitor)visitor);
        return result;
    }
}

