/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.gapp.importing;

import de.gaalop.cfg.AssignmentNode;
import de.gaalop.cfg.EmptyControlFlowVisitor;
import de.gaalop.dfg.ExpressionVisitor;
import de.gaalop.dfg.MultivectorComponent;
import de.gaalop.dfg.Variable;
import de.gaalop.gapp.GAPP;
import de.gaalop.gapp.importing.DotProductsFinder;
import de.gaalop.gapp.importing.ExpressionCollector;
import de.gaalop.gapp.importing.GAPPCreator;
import de.gaalop.gapp.importing.parallelObjects.DotProduct;
import de.gaalop.gapp.importing.parallelObjects.ExtCalculation;
import de.gaalop.gapp.importing.parallelObjects.ParVariable;
import de.gaalop.gapp.importing.parallelObjects.ParallelObject;
import de.gaalop.gapp.instructionSet.GAPPBaseInstruction;
import de.gaalop.gapp.instructionSet.GAPPCalculateMv;
import de.gaalop.gapp.instructionSet.GAPPResetMv;
import de.gaalop.gapp.variables.GAPPMultivector;
import de.gaalop.gapp.variables.GAPPMultivectorComponent;
import de.gaalop.tba.Algebra;
import java.util.HashSet;

public class GAPPDecorator
extends EmptyControlFlowVisitor {
    private HashSet<String> createdGAPPVariables = new HashSet();
    private GAPPCreator gappCreator;
    private GAPP gappStart;
    private int bladeCount;

    public GAPPDecorator(GAPP gappStart, HashSet<String> variables, int bladeCount, boolean scalarFunctions, Algebra algebra) {
        this.gappStart = gappStart;
        this.bladeCount = bladeCount;
        this.gappCreator = new GAPPCreator(variables, bladeCount, algebra);
    }

    public void visit(AssignmentNode node) {
        Variable variable;
        String name;
        GAPP gapp = new GAPP();
        node.setGAPP(gapp);
        this.gappCreator.setGapp(gapp);
        if (this.gappStart != null) {
            gapp.addGAPP(this.gappStart);
            this.gappStart = null;
        }
        if (!this.createdGAPPVariables.contains(name = (variable = node.getVariable()).getName())) {
            GAPPMultivector mv = new GAPPMultivector(name);
            gapp.addInstruction((GAPPBaseInstruction)new GAPPResetMv(mv, this.bladeCount));
            this.createdGAPPVariables.add(name);
        }
        ExpressionCollector collector = new ExpressionCollector();
        node.getValue().accept((ExpressionVisitor)collector);
        ParallelObject parallelObject = collector.getResultValue();
        DotProductsFinder finder = new DotProductsFinder();
        DotProduct newDot = (DotProduct)parallelObject.accept(finder, null);
        if (newDot != null) {
            parallelObject = newDot;
        }
        if (variable instanceof MultivectorComponent) {
            MultivectorComponent mvC = (MultivectorComponent)variable;
            GAPPMultivectorComponent gMvC = new GAPPMultivectorComponent(mvC.getName(), mvC.getBladeIndex());
            parallelObject.accept(this.gappCreator, gMvC);
        } else {
            ExtCalculation extCalculation = (ExtCalculation)parallelObject;
            gapp.addInstruction((GAPPBaseInstruction)new GAPPCalculateMv(extCalculation.getType(), new GAPPMultivector(variable.getName()), new GAPPMultivector(((ParVariable)extCalculation.getOperand1()).getName()), extCalculation.getOperand2() == null ? null : new GAPPMultivector(((ParVariable)extCalculation.getOperand2()).getName())));
        }
        super.visit(node);
    }
}

