/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.cli;

import de.gaalop.AlgebraStrategy;
import de.gaalop.AlgebraStrategyPlugin;
import de.gaalop.CodeGenerator;
import de.gaalop.CodeGeneratorPlugin;
import de.gaalop.CodeParser;
import de.gaalop.CodeParserPlugin;
import de.gaalop.CompilerFacade;
import de.gaalop.GlobalSettingsStrategy;
import de.gaalop.GlobalSettingsStrategyPlugin;
import de.gaalop.InputFile;
import de.gaalop.OptimizationStrategy;
import de.gaalop.OptimizationStrategyPlugin;
import de.gaalop.OutputFile;
import de.gaalop.Plugins;
import de.gaalop.VisualCodeInserterStrategy;
import de.gaalop.VisualCodeInserterStrategyPlugin;
import de.gaalop.algebra.DefinedAlgebra;
import de.gaalop.algebra.Plugin;
import de.gaalop.cli.SpecificOption;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.util.LinkedList;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;

public class Main {
    private Log log = LogFactory.getLog(Main.class);
    @Option(name="--cli", required=false, usage="Required to use this cli.")
    private boolean cli = false;
    @Option(name="--input", aliases={"-i"}, required=true, usage="The input file.")
    private String inputFile;
    @Option(name="--outputDir", aliases={"-o"}, required=false, usage="Sets the directory where the output files are created.")
    private String outputDirectory = "";
    @Option(name="--algebraName", aliases={"-a"}, required=false, usage="Sets the name of the algebra that should be used.")
    private String algebraName = "cga";
    @Option(name="--algebraBaseDir", aliases={"--ad"}, required=false, usage="Sets the base directory path of the user-defined algebras.")
    private String algebraBaseDirectory = null;
    @Option(name="--maximaPath", aliases={"-m"}, required=false, usage="Sets the maxima path and enables the usage of maxima.")
    private String maximaPath = "";
    @Option(name="--parserPlugin", aliases={"--pa"}, required=false, usage="Sets the class name of the code parser plugin that should be used.")
    private String codeParserPlugin = "de.gaalop.clucalc.input.Plugin";
    @Option(name="--globalSettingsPlugin", aliases={"--gs"}, required=false, usage="Sets the class name of the Global Settings Strategy plugin that should be used.")
    private String globalSettingsPlugin = "de.gaalop.globalSettings.Plugin";
    @Option(name="--visualCodeInserterPlugin", aliases={"--vc"}, required=false, usage="Sets the class name of the visual code inserter plugin that should be used.")
    private String visualCodeInserterPlugin = "de.gaalop.visualCodeInserter.Plugin";
    @Option(name="--algebraPlugin", aliases={"--al"}, required=false, usage="Sets the class name of the algebra strategy plugin that should be used.")
    private String algebraPlugin = "de.gaalop.algebra.Plugin";
    @Option(name="--optimizationPlugin", aliases={"--op"}, required=false, usage="Sets the class name of the optimization strategy plugin that should be used.")
    private String optimizationPlugin = "de.gaalop.tba.Plugin";
    @Option(name="--codeGeneratorPlugin", aliases={"--cg"}, required=false, usage="Sets the class name of the code generator plugin that should be used.")
    private String codeGeneratorPlugin = "de.gaalop.cpp.Plugin";
    @Option(name="--gapp", aliases={"-p"}, required=false, usage="Use the GAPP Optimization Plugin. Default: Disabled.")
    private boolean useGAPP = false;
    @Option(name="--specific", aliases={"--spec"}, required=false, usage="Sets specific configuration properties for plugins by a comma separated list. Syntax {Plugin1-Classname}:{Plugin1-Optionname}={Plugin1-Value},{Plugin2-Classname}:{Plugin2-Optionname}={Plugin2-Value}, ... . Defaults to ''.")
    private String specificOptions = "";
    private LinkedList<SpecificOption> specificOptionsList;

    public static void main(String[] args) throws Exception {
        Main main = new Main();
        CmdLineParser parser = new CmdLineParser((Object)main);
        try {
            parser.parseArgument(args);
            main.run();
        }
        catch (CmdLineException e) {
            System.err.println(e.getMessage());
            parser.printUsage((OutputStream)System.err);
        }
    }

    public void run() throws Exception {
        if (this.outputDirectory.trim().isEmpty()) {
            this.outputDirectory = new File(this.inputFile).getParent();
        }
        this.log.debug((Object)"Starting up compilation process.");
        if (this.useGAPP) {
            this.optimizationPlugin = "de.gaalop.gapp.Plugin";
        }
        CompilerFacade compiler = this.createCompiler();
        InputFile inputFile = this.getInputFile();
        Set outputFiles = compiler.compile(inputFile);
        for (OutputFile output : outputFiles) {
            this.writeFile(output);
        }
    }

    private void writeFile(OutputFile output) throws FileNotFoundException, UnsupportedEncodingException {
        if (this.outputDirectory.equals("-")) {
            this.printFileToConsole(output);
        } else {
            File outFile = new File(output.getName());
            if (!this.outputDirectory.trim().isEmpty()) {
                outFile = new File(this.outputDirectory, outFile.getName());
            }
            PrintWriter writer = new PrintWriter(outFile, output.getEncoding().name());
            writer.print(output.getContent());
            writer.close();
        }
    }

    private void printFileToConsole(OutputFile output) {
        System.out.println("----------------------------------------------------------");
        System.out.println("Output File: " + output.getName());
        System.out.println("----------------------------------------------------------");
        System.out.println(output.getContent());
        System.out.println("----------------------------------------------------------");
    }

    private CompilerFacade createCompiler() {
        this.specificOptionsList = SpecificOption.parseSpecificOptions(this.specificOptions);
        String path = this.maximaPath.trim();
        this.specificOptionsList.add(new SpecificOption("de.gaalop.globalSettings.Plugin", "maximaCommand", path));
        this.specificOptionsList.add(new SpecificOption("de.gaalop.globalSettings.Plugin", "optMaxima", path.isEmpty() ? "false" : "true"));
        CodeParser codeParser = this.createCodeParser();
        GlobalSettingsStrategy globalSettingsStrategy = this.createGlobalSettingsStrategy();
        AlgebraStrategy algebraStrategy = this.createAlgebraStrategy();
        VisualCodeInserterStrategy visualizerStrategy = this.createVisualizerStrategy();
        OptimizationStrategy optimizationStrategy = this.createOptimizationStrategy();
        CodeGenerator codeGenerator = this.createCodeGenerator();
        boolean asRessource = false;
        for (DefinedAlgebra definedAlgebra : Plugin.getDefinedAlgebras()) {
            if (!definedAlgebra.id.equals(this.algebraName.trim())) continue;
            asRessource = true;
        }
        return new CompilerFacade(codeParser, globalSettingsStrategy, visualizerStrategy, algebraStrategy, optimizationStrategy, codeGenerator, this.algebraName, asRessource, this.algebraBaseDirectory);
    }

    private void setSpecificOptionsForPlugin(Object plugin) {
        for (SpecificOption option : this.specificOptionsList) {
            if (!option.classname.equals(plugin.getClass().getName())) continue;
            try {
                Field optionField = plugin.getClass().getDeclaredField(option.optionname);
                optionField.setAccessible(true);
                Class<?> type = optionField.getType();
                if (type.equals(Boolean.TYPE)) {
                    optionField.setBoolean(plugin, Boolean.parseBoolean(option.value));
                    continue;
                }
                if (type.equals(Integer.TYPE)) {
                    optionField.setInt(plugin, Integer.parseInt(option.value));
                    continue;
                }
                if (type.equals(Long.TYPE)) {
                    optionField.setLong(plugin, Long.parseLong(option.value));
                    continue;
                }
                optionField.set(plugin, option.value);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException ex) {
                Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private CodeParser createCodeParser() {
        Set plugins = Plugins.getCodeParserPlugins();
        for (CodeParserPlugin plugin : plugins) {
            if (!plugin.getClass().getName().equals(this.codeParserPlugin)) continue;
            this.setSpecificOptionsForPlugin(plugin);
            return plugin.createCodeParser();
        }
        System.err.println("Unknown code parser plugin: " + this.codeParserPlugin);
        System.exit(-2);
        return null;
    }

    private GlobalSettingsStrategy createGlobalSettingsStrategy() {
        Set plugins = Plugins.getGlobalSettingsStrategyPlugins();
        for (GlobalSettingsStrategyPlugin plugin : plugins) {
            if (!plugin.getClass().getName().equals(this.globalSettingsPlugin)) continue;
            this.setSpecificOptionsForPlugin(plugin);
            return plugin.createGlobalSettingsStrategy();
        }
        System.err.println("Unknown global settings plugin: " + this.globalSettingsPlugin);
        System.exit(-3);
        return null;
    }

    private AlgebraStrategy createAlgebraStrategy() {
        Set plugins = Plugins.getAlgebraStrategyPlugins();
        for (AlgebraStrategyPlugin plugin : plugins) {
            if (!plugin.getClass().getName().equals(this.algebraPlugin)) continue;
            this.setSpecificOptionsForPlugin(plugin);
            return plugin.createAlgebraStrategy();
        }
        System.err.println("Unknown algebra plugin: " + this.algebraPlugin);
        System.exit(-3);
        return null;
    }

    private VisualCodeInserterStrategy createVisualizerStrategy() {
        Set plugins = Plugins.getVisualizerStrategyPlugins();
        for (VisualCodeInserterStrategyPlugin plugin : plugins) {
            if (!plugin.getClass().getName().equals(this.visualCodeInserterPlugin)) continue;
            this.setSpecificOptionsForPlugin(plugin);
            return plugin.createVisualCodeInserterStrategy();
        }
        System.err.println("Unknown visual code inserter plugin: " + this.visualCodeInserterPlugin);
        System.exit(-4);
        return null;
    }

    private OptimizationStrategy createOptimizationStrategy() {
        Set plugins = Plugins.getOptimizationStrategyPlugins();
        for (OptimizationStrategyPlugin plugin : plugins) {
            if (!plugin.getClass().getName().equals(this.optimizationPlugin)) continue;
            OptimizationStrategy strategy = plugin.createOptimizationStrategy();
            this.setSpecificOptionsForPlugin(plugin);
            return strategy;
        }
        System.err.println("Unknown optimization plugin: " + this.optimizationPlugin);
        System.exit(-5);
        return null;
    }

    private CodeGenerator createCodeGenerator() {
        Set plugins = Plugins.getCodeGeneratorPlugins();
        for (CodeGeneratorPlugin plugin : plugins) {
            if (!plugin.getClass().getName().equals(this.codeGeneratorPlugin)) continue;
            this.setSpecificOptionsForPlugin(plugin);
            return plugin.createCodeGenerator();
        }
        System.err.println("Unknown code generator plugin: " + this.codeGeneratorPlugin);
        System.exit(-6);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputFile getInputFile() throws Exception {
        String filename;
        InputStreamReader reader;
        if (this.inputFile.equals("-")) {
            reader = new InputStreamReader(System.in);
            filename = "calculate";
        } else {
            reader = new FileReader(this.inputFile);
            filename = new File(this.inputFile).getName();
        }
        try {
            String line;
            BufferedReader bufReader = new BufferedReader(reader);
            StringBuilder result = new StringBuilder();
            while ((line = bufReader.readLine()) != null) {
                result.append(line);
                result.append('\n');
            }
            InputFile inputFile = new InputFile(filename, result.toString());
            return inputFile;
        }
        finally {
            ((Reader)reader).close();
        }
    }
}

