/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.python;

import de.gaalop.NonarrayCodeGeneratorVisitor;
import de.gaalop.StringList;
import de.gaalop.cfg.AssignmentNode;
import de.gaalop.cfg.ColorNode;
import de.gaalop.cfg.ControlFlowVisitor;
import de.gaalop.cfg.EndNode;
import de.gaalop.cfg.ExpressionStatement;
import de.gaalop.cfg.StartNode;
import de.gaalop.cfg.StoreResultNode;
import de.gaalop.dfg.Exponentiation;
import de.gaalop.dfg.Expression;
import de.gaalop.dfg.ExpressionVisitor;
import de.gaalop.dfg.FloatConstant;
import de.gaalop.dfg.MathFunctionCall;
import de.gaalop.dfg.Multiplication;
import de.gaalop.dfg.MultivectorComponent;
import de.gaalop.dfg.Negation;
import de.gaalop.dfg.Variable;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class PythonVisitor
extends NonarrayCodeGeneratorVisitor {
    protected String variableType = "float";
    protected String filename;
    private HashMap<String, LinkedList<Integer>> mvComponents = new HashMap();

    public PythonVisitor(boolean useDouble, String filename, boolean useArrays) {
        this.filename = filename;
        if (useDouble) {
            this.variableType = "double";
        }
        this.useArrays = useArrays;
    }

    public PythonVisitor(String variableType) {
        this.variableType = variableType;
    }

    protected Boolean useNamedTuples() {
        return false;
    }

    public void visit(StartNode node) {
        this.declaredVariableNames.clear();
        this.graph = node.getGraph();
        this.libraries.add("import numpy as np");
        this.addLine();
        this.appendIndentation();
        this.addCode("def " + this.filename.toLowerCase() + "(");
        StringList inputs = this.graph.getInputs();
        this.addCode(inputs.join());
        this.addCode("):\n");
        ++this.indentation;
        node.getSuccessor().accept((ControlFlowVisitor)this);
    }

    public void visit(AssignmentNode node) {
        String varName = this.getNewName(node.getVariable());
        if (this.declaredVariableNames.add(varName) && this.useArrays.booleanValue()) {
            varName = node.getVariable().getName();
            this.addLine(varName + " = np.zeros(" + node.getGraph().getAlgebraDefinitionFile().blades2.length + ")");
        }
        this.appendIndentation();
        node.getVariable().accept((ExpressionVisitor)this);
        this.addCode(" = ");
        node.getValue().accept((ExpressionVisitor)this);
        if (this.useArrays.booleanValue() && node.getVariable() instanceof MultivectorComponent) {
            this.addCode(" # ");
            MultivectorComponent component = (MultivectorComponent)node.getVariable();
            this.addCode(this.graph.getBladeString(component));
            if (!this.mvComponents.containsKey(component.getName())) {
                this.mvComponents.put(component.getName(), new LinkedList());
            }
            this.mvComponents.get(component.getName()).add(component.getBladeIndex());
        }
        this.addCode('\n');
        node.getSuccessor().accept((ControlFlowVisitor)this);
    }

    public void visit(ExpressionStatement node) {
        node.getSuccessor().accept((ControlFlowVisitor)this);
    }

    public void visit(StoreResultNode node) {
        node.getSuccessor().accept((ControlFlowVisitor)this);
    }

    public void visit(EndNode node) {
        super.visit(node);
        if (this.useArrays.booleanValue()) {
            this.appendIndentation();
            this.addCode("return " + this.graph.getOutputs().join());
        }
        if (!this.libraries.isEmpty()) {
            LinkedList<String> libs = new LinkedList<String>(this.libraries);
            libs.sort(new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    return o2.compareTo(o1);
                }
            });
            for (String lib : libs) {
                this.code.insert(0, lib + "\n");
            }
            String text = this.code.toString();
            if (text.contains("sin(") || text.contains("cos(")) {
                this.code.insert(0, "from math import sin, cos\n");
            }
        }
    }

    public void visit(ColorNode node) {
        node.getSuccessor().accept((ControlFlowVisitor)this);
    }

    public void visit(MathFunctionCall mathFunctionCall) {
        String funcName;
        this.libraries.add("import math");
        switch (mathFunctionCall.getFunction()) {
            case ABS: {
                funcName = "abs";
                break;
            }
            case SQRT: {
                funcName = "math.sqrt";
                break;
            }
            default: {
                funcName = mathFunctionCall.getFunction().toString().toLowerCase();
            }
        }
        this.addCode(funcName);
        this.addCode('(');
        mathFunctionCall.getOperand().accept((ExpressionVisitor)this);
        this.addCode(')');
    }

    public void visit(Variable variable) {
        this.addCode(this.getNewName(variable));
    }

    public void visit(MultivectorComponent component) {
        String name = component.getNewName(this.graph, this.useArrays);
        this.addCode(name);
    }

    public void visit(Exponentiation exponentiation) {
        if (this.isSquare(exponentiation)) {
            Multiplication m = new Multiplication(exponentiation.getLeft(), exponentiation.getLeft());
            m.accept((ExpressionVisitor)this);
        } else {
            this.addCode("pow(");
            exponentiation.getLeft().accept((ExpressionVisitor)this);
            this.addCode(',');
            exponentiation.getRight().accept((ExpressionVisitor)this);
            this.addCode(')');
        }
    }

    public void visit(FloatConstant floatConstant) {
        this.addCode(Double.toString(floatConstant.getValue()));
    }

    public void visit(Negation negation) {
        this.addCode('(');
        this.addCode('-');
        this.addChild((Expression)negation, negation.getOperand());
        this.addCode(')');
    }

    protected void addReturnType(List<String> returnTypes) {
        this.libraries.add("from typing import Tuple");
        String typeString = String.join((CharSequence)", ", returnTypes);
        String totalReturnType = returnTypes.size() == 1 ? typeString : "Tuple[" + typeString + "]";
        this.replaceInCode("):", ") -> " + totalReturnType + ":");
    }
}

