/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.latex;

import de.gaalop.DefaultCodeGeneratorVisitor;
import de.gaalop.cfg.AssignmentNode;
import de.gaalop.cfg.BlockEndNode;
import de.gaalop.cfg.BreakNode;
import de.gaalop.cfg.ColorNode;
import de.gaalop.cfg.ControlFlowVisitor;
import de.gaalop.cfg.EndNode;
import de.gaalop.cfg.ExpressionStatement;
import de.gaalop.cfg.IfThenElseNode;
import de.gaalop.cfg.LoopNode;
import de.gaalop.cfg.StartNode;
import de.gaalop.cfg.StoreResultNode;
import de.gaalop.dfg.Addition;
import de.gaalop.dfg.BaseVector;
import de.gaalop.dfg.BinaryOperation;
import de.gaalop.dfg.Division;
import de.gaalop.dfg.Equality;
import de.gaalop.dfg.Exponentiation;
import de.gaalop.dfg.Expression;
import de.gaalop.dfg.ExpressionVisitor;
import de.gaalop.dfg.FloatConstant;
import de.gaalop.dfg.Inequality;
import de.gaalop.dfg.InnerProduct;
import de.gaalop.dfg.LogicalAnd;
import de.gaalop.dfg.LogicalNegation;
import de.gaalop.dfg.LogicalOr;
import de.gaalop.dfg.MathFunctionCall;
import de.gaalop.dfg.Multiplication;
import de.gaalop.dfg.MultivectorComponent;
import de.gaalop.dfg.Negation;
import de.gaalop.dfg.OuterProduct;
import de.gaalop.dfg.Relation;
import de.gaalop.dfg.Reverse;
import de.gaalop.dfg.Subtraction;
import de.gaalop.dfg.Variable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LatexVisitor
extends DefaultCodeGeneratorVisitor {
    private Pattern INDEXED_NUMBER = Pattern.compile("^(\\w+)(\\d+)$");
    private static final FloatConstant HALF = new FloatConstant(0.5);
    private static final Negation MINUS_HALF = new Negation((Expression)HALF);
    private static final Division ONE_HALF = new Division((Expression)new FloatConstant(1.0), (Expression)new FloatConstant(2.0));
    private static final Negation MINUS_ONE_HALF = new Negation((Expression)ONE_HALF);

    public void visit(StartNode node) {
        this.graph = node.getGraph();
        this.code.append("\\begin{align*}\n");
        node.getSuccessor().accept((ControlFlowVisitor)this);
    }

    public void visit(AssignmentNode node) {
        node.getVariable().accept((ExpressionVisitor)this);
        this.code.append("&= ");
        node.getValue().accept((ExpressionVisitor)this);
        if (node.getVariable() instanceof MultivectorComponent) {
            this.code.append(" // ");
            this.code.append(this.graph.getBladeString((MultivectorComponent)node.getVariable()).replaceAll("\\^", "\\\\wedge"));
            this.code.append(" ");
        }
        this.code.append("\\\\\n");
        node.getSuccessor().accept((ControlFlowVisitor)this);
    }

    public void visit(ExpressionStatement node) {
        node.getExpression().accept((ExpressionVisitor)this);
        this.code.append("\\\\\n");
        node.getSuccessor().accept((ControlFlowVisitor)this);
    }

    public void visit(StoreResultNode node) {
        node.getSuccessor().accept((ControlFlowVisitor)this);
    }

    public void visit(IfThenElseNode node) {
        this.code.append("\\text{IF } (");
        node.getCondition().accept((ExpressionVisitor)this);
        this.code.append(") \\\\\n");
        node.getPositive().accept((ControlFlowVisitor)this);
        if (!(node.getNegative() instanceof BlockEndNode)) {
            this.code.append("\\text{ELSE} \\\\\n");
            node.getNegative().accept((ControlFlowVisitor)this);
        }
        this.code.append("\\text{END IF} \\\\\n");
        node.getSuccessor().accept((ControlFlowVisitor)this);
    }

    public void visit(LoopNode node) {
        this.code.append("\\text{LOOP} \\\\\n");
        node.getBody().accept((ControlFlowVisitor)this);
        this.code.append("\\text{END LOOP} \\\\\n");
        node.getSuccessor().accept((ControlFlowVisitor)this);
    }

    public void visit(BreakNode breakNode) {
        this.code.append("\\text{break}\\\\");
        breakNode.getSuccessor().accept((ControlFlowVisitor)this);
    }

    public void visit(EndNode node) {
        this.code.append("\\end{align*}\n");
    }

    public void visit(Subtraction subtraction) {
        this.addBinaryInfix((BinaryOperation)subtraction, "-");
    }

    public void visit(Addition addition) {
        this.addBinaryInfix((BinaryOperation)addition, "+");
    }

    public void visit(Division division) {
        this.code.append("\\cfrac{");
        division.getLeft().accept((ExpressionVisitor)this);
        this.code.append("}{");
        division.getRight().accept((ExpressionVisitor)this);
        this.code.append("}");
    }

    public void visit(InnerProduct innerProduct) {
        this.addBinaryInfix((BinaryOperation)innerProduct, "\\cdot");
    }

    public void visit(Multiplication multiplication) {
        if (multiplication.getLeft().equals(HALF)) {
            ONE_HALF.accept((ExpressionVisitor)this);
            multiplication.getRight().accept((ExpressionVisitor)this);
        } else if (multiplication.getRight().equals(HALF)) {
            ONE_HALF.accept((ExpressionVisitor)this);
            multiplication.getLeft().accept((ExpressionVisitor)this);
        } else if (multiplication.getLeft().equals(MINUS_HALF)) {
            MINUS_ONE_HALF.accept((ExpressionVisitor)this);
            multiplication.getRight().accept((ExpressionVisitor)this);
        } else if (multiplication.getRight().equals(MINUS_HALF)) {
            MINUS_ONE_HALF.accept((ExpressionVisitor)this);
            multiplication.getLeft().accept((ExpressionVisitor)this);
        } else {
            this.addBinaryInfix((BinaryOperation)multiplication, "*");
        }
    }

    public void visit(MathFunctionCall mathFunctionCall) {
        this.code.append(mathFunctionCall.getFunction().toString());
        this.code.append('(');
        mathFunctionCall.getOperand().accept((ExpressionVisitor)this);
        this.code.append(')');
    }

    public void visit(Variable variable) {
        String name = variable.getName();
        this.code.append(name.replace("_", "\\_"));
    }

    private void addIdentifier(String name) {
        Matcher matcher = this.INDEXED_NUMBER.matcher(name);
        if (matcher.matches()) {
            this.code.append(matcher.group(1).replace("_", "\\_"));
            this.code.append("_{");
            this.code.append(matcher.group(2));
            this.code.append("}");
        } else {
            this.code.append(name.replace("_", "\\_"));
        }
    }

    public void visit(MultivectorComponent component) {
        this.addIdentifier(component.getName().replace("_opt", ""));
        this.code.append("_{");
        this.code.append(component.getBladeIndex());
        this.code.append('}');
    }

    public void visit(Exponentiation exponentiation) {
        exponentiation.getLeft().accept((ExpressionVisitor)this);
        this.code.append("^{");
        exponentiation.getRight().accept((ExpressionVisitor)this);
        this.code.append('}');
    }

    public void visit(FloatConstant floatConstant) {
        if (Double.isNaN(floatConstant.getValue())) {
            this.code.append("undefined");
        } else if (Double.compare(floatConstant.getValue(), Math.floor(floatConstant.getValue())) == 0) {
            this.code.append((int)floatConstant.getValue());
        } else {
            this.code.append(Double.toString(floatConstant.getValue()));
        }
    }

    public void visit(OuterProduct outerProduct) {
        this.addBinaryInfix((BinaryOperation)outerProduct, "\\wedge");
    }

    public void visit(BaseVector baseVector) {
        this.code.append("e_{");
        this.code.append(baseVector.getIndex());
        this.code.append('}');
    }

    public void visit(Negation negation) {
        this.code.append('-');
        negation.getOperand().accept((ExpressionVisitor)this);
    }

    public void visit(Reverse node) {
        this.code.append('~');
        node.getOperand().accept((ExpressionVisitor)this);
    }

    public void visit(LogicalOr node) {
        this.addBinaryInfix((BinaryOperation)node, " \\vee ");
    }

    public void visit(LogicalAnd node) {
        this.addBinaryInfix((BinaryOperation)node, " \\wedge ");
    }

    public void visit(LogicalNegation node) {
        this.code.append("!");
        node.getOperand().accept((ExpressionVisitor)this);
    }

    public void visit(Equality node) {
        this.addBinaryInfix((BinaryOperation)node, " == ");
    }

    public void visit(Inequality node) {
        this.addBinaryInfix((BinaryOperation)node, " \neq ");
    }

    public void visit(Relation relation) {
        this.addBinaryInfix((BinaryOperation)relation, relation.getTypeString());
    }

    public void visit(ColorNode node) {
        node.getSuccessor().accept((ControlFlowVisitor)this);
    }
}

