/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.vis2d;

import de.gaalop.CodeGenerator;
import de.gaalop.CodeGeneratorException;
import de.gaalop.OutputFile;
import de.gaalop.cfg.ColorNode;
import de.gaalop.cfg.ControlFlowGraph;
import de.gaalop.cfg.UnknownMacroCall;
import de.gaalop.dfg.Expression;
import de.gaalop.dfg.FloatConstant;
import de.gaalop.dfg.MacroCall;
import de.gaalop.dfg.Variable;
import de.gaalop.vis2d.ColorEvaluater;
import de.gaalop.vis2d.FindOutputVariableNames;
import de.gaalop.vis2d.Interaction;
import de.gaalop.vis2d.Multivector;
import de.gaalop.vis2d.MultivectorBuilder;
import de.gaalop.vis2d.MyPanel;
import de.gaalop.vis2d.Stretch2d;
import de.gaalop.vis2d.ValueEvaluater;
import de.gaalop.vis2d.Vis2dUI;
import de.gaalop.vis2d.drawing.Circle2d;
import de.gaalop.vis2d.drawing.CircleDashed2d;
import de.gaalop.vis2d.drawing.DrawVisitorBufferedImage;
import de.gaalop.vis2d.drawing.DrawVisitorGraphics;
import de.gaalop.vis2d.drawing.Drawing;
import de.gaalop.vis2d.drawing.Gerade2d;
import de.gaalop.vis2d.drawing.Point2d;
import de.gaalop.vis2d.drawing.Pointpair2d;
import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class Vis2dCodeGen
implements CodeGenerator {
    private static final double EPSILON = 0.001;
    public Drawing drawing = new Drawing();
    public Rectangle2D.Double world = new Rectangle2D.Double(-5.0, -5.0, 10.0, 10.0);
    public MyPanel panel;
    public DrawVisitorGraphics visitor;
    public Vis2dUI vis2dUI;
    private ControlFlowGraph graph;
    private HashMap<String, double[]> values;

    private void printMultivector(String name, Multivector mv) {
        for (int bladeIndex = 0; bladeIndex < mv.entries.length; ++bladeIndex) {
            if (!(Math.abs(mv.entries[bladeIndex]) > 0.001)) continue;
            System.out.println(name + "(" + bladeIndex + ") = " + mv.entries[bladeIndex] + " // " + this.graph.getAlgebraDefinitionFile().getBladeString(bladeIndex));
        }
    }

    public Set<OutputFile> generate(ControlFlowGraph in) throws CodeGeneratorException {
        this.graph = in;
        this.values = ValueEvaluater.evaluateValues(in);
        HashMap<String, Color> colors = ColorEvaluater.getColors(in);
        this.drawing.objects.clear();
        HashMap<String, Multivector> mapMv = MultivectorBuilder.buildMultivectors(in);
        for (String name : FindOutputVariableNames.getVariableNames(in)) {
            if (in.getRenderingExpressions().containsKey(name)) continue;
            if (!mapMv.containsKey(name)) {
                System.err.println("Programming error Vis2dCodeGen");
                new Exception().printStackTrace();
                continue;
            }
            this.printMultivector(name, mapMv.get(name));
        }
        this.drawUnknownMacros(in.unknownMacros);
        for (String s : in.getRenderingExpressions().keySet()) {
            this.interpret(mapMv.get(s), colors.get(s));
        }
        this.vis2dUI = new Vis2dUI();
        this.panel = (MyPanel)this.vis2dUI.jPanel1;
        Interaction interaction = new Interaction(this);
        interaction.initialize();
        this.vis2dUI.setDefaultCloseOperation(2);
        this.vis2dUI.setVisible(true);
        this.repaintDrawing();
        return new HashSet<OutputFile>();
    }

    public void repaintDrawing() {
        this.visitor = new DrawVisitorBufferedImage(this.world, 500, 500);
        this.panel.set(this.drawing, this.visitor);
        this.drawing.draw(this.visitor);
        this.panel.repaint();
    }

    private void interpret(Multivector mv, Color c) {
        boolean[] nonZero = this.getNonZeroComponents(mv.entries);
        if (this.hasBivecParts16(nonZero)) {
            this.interpretPointPair(mv, c, nonZero);
        } else {
            double e0 = mv.entries[4];
            if (Math.abs(e0) < 0.001) {
                double ox = 0.0;
                double oy = 0.0;
                double dx = 0.0;
                double dy = 0.0;
                if (Math.abs(mv.entries[2]) < 0.001) {
                    ox = mv.entries[3] / mv.entries[1];
                    dy = 1.0;
                } else {
                    dx = 1.0;
                    dy = -mv.entries[1] / mv.entries[2];
                    oy = mv.entries[3] / mv.entries[2];
                }
                this.drawing.objects.add(new Gerade2d(ox, oy, dx, dy, c));
            } else {
                double x = mv.entries[1] / e0;
                double y = mv.entries[2] / e0;
                double r = Math.sqrt(Math.abs(2.0 * mv.entries[3] * mv.entries[4] - mv.entries[2] * mv.entries[2] - mv.entries[1] * mv.entries[1])) / Math.abs(mv.entries[4]);
                if (r < 0.001) {
                    this.drawing.objects.add(new Point2d(x, y, c));
                } else if (x * x + y * y - 2.0 * mv.entries[3] / e0 < 0.0) {
                    this.drawing.objects.add(new CircleDashed2d(x, y, r, c));
                } else {
                    this.drawing.objects.add(new Circle2d(x, y, r, c));
                }
            }
        }
    }

    private boolean[] getNonZeroComponents(double[] entries) {
        boolean[] result = new boolean[entries.length];
        for (int i = 0; i < entries.length; ++i) {
            result[i] = Math.abs(entries[i]) > 0.001;
        }
        return result;
    }

    private boolean hasBivecParts16(boolean[] nonZero) {
        for (int i = 5; i <= 10; ++i) {
            if (!nonZero[i]) continue;
            return true;
        }
        return false;
    }

    private void interpretPointPair(Multivector mv, Color c, boolean[] nonZero) {
        double[] b = mv.entries;
        double x1 = (b[9] * Math.sqrt(Math.abs(2.0 * b[8] * b[9] + 2.0 * b[6] * b[7] - b[5] * b[5] + b[10] * b[10])) - b[5] * b[9] + b[10] * b[7]) / (b[9] * b[9] + b[7] * b[7]);
        double y1 = -((b[7] * Math.sqrt(Math.abs(2.0 * b[8] * b[9] + 2.0 * b[6] * b[7] - b[5] * b[5] + b[10] * b[10])) - b[10] * b[9] - b[5] * b[7]) / (b[9] * b[9] + b[7] * b[7]));
        double x2 = -((b[9] * Math.sqrt(Math.abs(2.0 * b[8] * b[9] + 2.0 * b[6] * b[7] - b[5] * b[5] + b[10] * b[10])) + b[5] * b[9] - b[10] * b[7]) / (b[9] * b[9] + b[7] * b[7]));
        double y2 = (b[7] * Math.sqrt(Math.abs(2.0 * b[8] * b[9] + 2.0 * b[6] * b[7] - b[5] * b[5] + b[10] * b[10])) + b[10] * b[9] + b[5] * b[7]) / (b[9] * b[9] + b[7] * b[7]);
        if (!(Double.isNaN(x1) || Double.isNaN(y1) || Double.isNaN(x2) || Double.isNaN(y2))) {
            this.drawing.objects.add(new Pointpair2d(x1, y1, x2, y2, c));
        } else if (nonZero[5]) {
            this.drawing.objects.add(new Point2d(-(b[8] / b[5]), b[6] / b[5], c));
        }
    }

    private void drawUnknownMacros(LinkedList<UnknownMacroCall> unknownMacros) {
        for (UnknownMacroCall unknownMacroCall : unknownMacros) {
            MacroCall macroCall = unknownMacroCall.macroCall;
            Color color = this.getColor(unknownMacroCall.colorNode);
            String name = macroCall.getName();
            if (name.equals("DrawArrow")) {
                this.drawArrow(macroCall.getArguments(), color);
                continue;
            }
            if (name.equals("DrawLine")) {
                this.drawLine(macroCall.getArguments(), color);
                continue;
            }
            if (name.equals("DrawTriangle")) {
                this.drawTriangle(macroCall.getArguments(), color);
                continue;
            }
            System.out.println("Unknown macro: " + name);
        }
    }

    private void drawArrow(List<Expression> arguments, Color color) {
        throw new UnsupportedOperationException("DrawArrow is not implemented yet");
    }

    private double[] getCoordFromMv(Expression mvE) {
        double[] result = new double[2];
        double[] mv = this.values.get(((Variable)mvE).getName());
        result[0] = mv[1] / mv[4];
        result[1] = mv[2] / mv[4];
        return result;
    }

    private void drawLine(List<Expression> arguments, Color color) {
        double y2;
        double x2;
        double y1;
        double x1;
        switch (arguments.size()) {
            case 2: {
                double[] startMv = this.getCoordFromMv(arguments.get(0));
                double[] endMv = this.getCoordFromMv(arguments.get(1));
                x1 = startMv[0];
                y1 = startMv[1];
                x2 = endMv[0];
                y2 = endMv[1];
                break;
            }
            case 4: {
                x1 = this.getValueOfExpression(arguments.get(0));
                y1 = this.getValueOfExpression(arguments.get(1));
                x2 = this.getValueOfExpression(arguments.get(2));
                y2 = this.getValueOfExpression(arguments.get(3));
                break;
            }
            default: {
                return;
            }
        }
        this.drawing.objects.add(new Stretch2d(x1, y1, x2, y2, color));
    }

    private void drawTriangle(List<Expression> arguments, Color color) {
        double y3;
        double x3;
        double y2;
        double x2;
        double y1;
        double x1;
        switch (arguments.size()) {
            case 3: {
                double[] p1 = this.getCoordFromMv(arguments.get(0));
                double[] p2 = this.getCoordFromMv(arguments.get(1));
                double[] p3 = this.getCoordFromMv(arguments.get(2));
                x1 = p1[0];
                y1 = p1[1];
                x2 = p2[0];
                y2 = p2[1];
                x3 = p3[0];
                y3 = p3[1];
                break;
            }
            case 6: {
                x1 = this.getValueOfExpression(arguments.get(0));
                y1 = this.getValueOfExpression(arguments.get(1));
                x2 = this.getValueOfExpression(arguments.get(2));
                y2 = this.getValueOfExpression(arguments.get(3));
                x3 = this.getValueOfExpression(arguments.get(4));
                y3 = this.getValueOfExpression(arguments.get(5));
                break;
            }
            default: {
                return;
            }
        }
        this.drawing.objects.add(new Stretch2d(x1, y1, x2, y2, color));
        this.drawing.objects.add(new Stretch2d(x1, y1, x3, y3, color));
        this.drawing.objects.add(new Stretch2d(x2, y2, x3, y3, color));
    }

    private Color getColor(ColorNode colorNode) {
        if (colorNode == null) {
            return Color.black;
        }
        return new Color((float)this.getValueOfExpression(colorNode.getR()), (float)this.getValueOfExpression(colorNode.getG()), (float)this.getValueOfExpression(colorNode.getB()), (float)this.getValueOfExpression(colorNode.getAlpha()));
    }

    private double getValueOfExpression(Expression e) {
        if (e instanceof FloatConstant) {
            return ((FloatConstant)e).getValue();
        }
        return this.values.get(((Variable)e).getName())[0];
    }
}

