/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.vis2d.drawing;

import de.gaalop.vis2d.Stretch2d;
import de.gaalop.vis2d.drawing.Circle2d;
import de.gaalop.vis2d.drawing.CircleDashed2d;
import de.gaalop.vis2d.drawing.DrawVisitor;
import de.gaalop.vis2d.drawing.Gerade2d;
import de.gaalop.vis2d.drawing.Point2d;
import de.gaalop.vis2d.drawing.Pointpair2d;
import de.gaalop.vis2d.drawing.Text2d;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class DrawVisitorGraphics
implements DrawVisitor {
    protected Rectangle2D world;
    private Graphics graphics;
    protected int dimension;
    protected double scale;

    public DrawVisitorGraphics(Rectangle2D world, int width, int height) {
        this.world = world;
        this.scale = Math.min((double)width / world.getWidth(), (double)height / world.getHeight());
        this.dimension = (int)Math.round(world.getWidth() * this.scale);
    }

    public void setGraphics(Graphics graphics) {
        this.graphics = graphics;
        graphics.setFont(new Font("Arial", 0, 12));
    }

    private Point transformPoint(double x, double y) {
        return new Point((int)Math.round((x - this.world.getMinX()) * this.scale), (int)Math.round((double)this.dimension - (y - this.world.getMinY()) * this.scale));
    }

    private double transformLength(double length) {
        return this.transformPoint(0.0, 0.0).distance(this.transformPoint(0.0, length));
    }

    public Point2D.Double transformPointBack(int x, int y) {
        return new Point2D.Double(this.world.getMinX() + (double)x / this.scale, this.world.getMinY() - (double)(y - this.dimension) / this.scale);
    }

    @Override
    public void visitCircle2d(Circle2d circle2d) {
        this.graphics.setColor(circle2d.color);
        int ovalWidth = (int)Math.round(this.transformLength(circle2d.radius * 2.0));
        Point location = this.transformPoint(circle2d.centerX, circle2d.centerY);
        this.graphics.drawOval(location.x - ovalWidth / 2, location.y - ovalWidth / 2, ovalWidth, ovalWidth);
    }

    @Override
    public void visitCircleDashed2d(CircleDashed2d circleDashed2d) {
        Graphics2D g = (Graphics2D)this.graphics;
        Stroke s = g.getStroke();
        float[] dash1 = new float[]{10.0f};
        BasicStroke dashed = new BasicStroke(1.0f, 0, 0, 10.0f, dash1, 0.0f);
        g.setStroke(dashed);
        this.graphics.setColor(circleDashed2d.color);
        int ovalWidth = (int)Math.round(this.transformLength(circleDashed2d.radius * 2.0));
        Point location = this.transformPoint(circleDashed2d.centerX, circleDashed2d.centerY);
        this.graphics.drawOval(location.x - ovalWidth / 2, location.y - ovalWidth / 2, ovalWidth, ovalWidth);
        g.setStroke(s);
    }

    @Override
    public void visitGerade2d(Gerade2d gerade2d) {
        this.graphics.setColor(gerade2d.color);
        Line2D line = gerade2d.getLineOnRectangle(this.world);
        if (line != null) {
            Point start = this.transformPoint(line.getX1(), line.getY1());
            Point end = this.transformPoint(line.getX2(), line.getY2());
            this.graphics.drawLine(start.x, start.y, end.x, end.y);
        }
    }

    @Override
    public void visitPoint2d(Point2d point2d) {
        this.graphics.setColor(point2d.color);
        Point p = this.transformPoint(point2d.centerX, point2d.centerY);
        this.graphics.fillOval(p.x - 3, p.y - 3, 6, 6);
    }

    @Override
    public void visitPointpair2d(Pointpair2d pointpair2d) {
        this.graphics.setColor(pointpair2d.color);
        Point p1 = this.transformPoint(pointpair2d.p1X, pointpair2d.p1Y);
        this.graphics.fillOval(p1.x - 3, p1.y - 3, 6, 6);
        Point p2 = this.transformPoint(pointpair2d.p2X, pointpair2d.p2Y);
        this.graphics.fillOval(p2.x - 3, p2.y - 3, 6, 6);
    }

    @Override
    public void drawKOS() {
        double y;
        double x;
        double dx = this.world.getWidth() / 10.0;
        double dy = this.world.getHeight() / 10.0;
        for (x = 0.0; x >= this.world.getMinX(); x -= dx) {
            this.visitGerade2d(new Gerade2d(x, 0.0, 0.0, 1.0, Color.lightGray));
            this.visitText2d(new Text2d(x, 0.0, x + "", Color.lightGray));
        }
        for (x = 0.0; x <= this.world.getMaxX(); x += dx) {
            this.visitGerade2d(new Gerade2d(x, 0.0, 0.0, 1.0, Color.lightGray));
            this.visitText2d(new Text2d(x, 0.0, x + "", Color.lightGray));
        }
        for (y = 0.0; y >= this.world.getMinY(); y -= dy) {
            this.visitGerade2d(new Gerade2d(0.0, y, 1.0, 0.0, Color.lightGray));
            this.visitText2d(new Text2d(0.0, y, y + "", Color.lightGray));
        }
        for (y = 0.0; y <= this.world.getMaxY(); y += dy) {
            this.visitGerade2d(new Gerade2d(0.0, y, 1.0, 0.0, Color.lightGray));
            this.visitText2d(new Text2d(0.0, y, y + "", Color.lightGray));
        }
        this.visitGerade2d(new Gerade2d(0.0, 0.0, 0.0, 1.0, Color.darkGray));
        this.visitGerade2d(new Gerade2d(0.0, 0.0, 1.0, 0.0, Color.darkGray));
    }

    @Override
    public void visitText2d(Text2d text2d) {
        this.graphics.setColor(text2d.color);
        Point p = this.transformPoint(text2d.x, text2d.y);
        this.graphics.drawString(text2d.text, p.x, p.y);
    }

    @Override
    public void visitStretch2d(Stretch2d stretch2d) {
        this.graphics.setColor(stretch2d.color);
        Point start = this.transformPoint(stretch2d.x1, stretch2d.y1);
        Point end = this.transformPoint(stretch2d.x2, stretch2d.y2);
        this.graphics.drawLine(start.x, start.y, end.x, end.y);
    }
}

