/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.algebra;

import de.gaalop.AlgebraStrategy;
import de.gaalop.CodeParserException;
import de.gaalop.InputFile;
import de.gaalop.OptimizationException;
import de.gaalop.algebra.BaseVectorDefiner;
import de.gaalop.algebra.BaseVectorReplaceVisitor;
import de.gaalop.algebra.BladeArrayRoutines;
import de.gaalop.algebra.Inliner;
import de.gaalop.algebra.MacrosVisitor;
import de.gaalop.algebra.Plugin;
import de.gaalop.algebra.RecursionChecker;
import de.gaalop.algebra.StringIntContainer;
import de.gaalop.algebra.TCBlade;
import de.gaalop.algebra.UpdateLocalVariableSet;
import de.gaalop.cfg.AlgebraDefinitionFile;
import de.gaalop.cfg.AssignmentNode;
import de.gaalop.cfg.ControlFlowGraph;
import de.gaalop.cfg.ControlFlowVisitor;
import de.gaalop.cfg.Macro;
import de.gaalop.cfg.SequentialNode;
import de.gaalop.dfg.Expression;
import de.gaalop.dfg.OuterProduct;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AlStrategy
implements AlgebraStrategy {
    private Plugin plugin;

    public AlStrategy(Plugin plugin) {
        this.plugin = plugin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transform(ControlFlowGraph graph) throws OptimizationException {
        if (graph.getOutputs().isEmpty() && this.plugin.atLeastOneQuestionSignedRequired) {
            throw new OptimizationException("There are no lines marked for optimization ('?')", graph);
        }
        Reader reader = null;
        try {
            String baseDir;
            AlgebraDefinitionFile alFile = graph.getAlgebraDefinitionFile();
            alFile.setUsePrecalculatedTable(this.plugin.usePrecalulatedTables);
            alFile.setUseAsRessource(graph.asRessource);
            String string = baseDir = graph.asRessource ? "algebra" : graph.algebraBaseDirectory;
            if (!baseDir.endsWith("/")) {
                baseDir = baseDir + "/";
            }
            baseDir = baseDir + graph.algebraName + "/";
            alFile.setProductsFilePath(baseDir + "products.csv");
            if (this.plugin.algebraDefinitionString == null) {
                alFile.setProductsFilePath(baseDir + "products.csv");
                reader = graph.asRessource ? new InputStreamReader(this.getClass().getResourceAsStream(baseDir + "definition.csv")) : new FileReader(new File(baseDir + "definition.csv"));
            } else {
                reader = new StringReader(this.plugin.algebraDefinitionString);
            }
            alFile.loadFromFile(reader);
            AlStrategy.createBlades(alFile);
            reader = graph.asRessource ? new InputStreamReader(this.getClass().getResourceAsStream(baseDir + "macros.clu")) : new FileReader(new File(baseDir + "macros.clu"));
            ControlFlowGraph macrosGraph = new de.gaalop.clucalc.input.Plugin().createCodeParser().parseFile(this.inputStreamToInputFile(reader, "macros", null));
            reader.close();
            HashMap<StringIntContainer, Macro> macros = MacrosVisitor.getAllMacros(macrosGraph);
            MacrosVisitor.getAllMacros(graph, macros);
            StringIntContainer dual = new StringIntContainer("Dual", 1);
            if (macros.containsKey(dual)) {
                macros.put(new StringIntContainer("*", 1), macros.get(dual));
            }
            if (!this.plugin.getUserMacroFilePath().trim().equals("")) {
                File f = new File(this.plugin.userMacroFilePath);
                if (f.exists()) {
                    reader = new FileReader(f);
                    ControlFlowGraph userMacrosGraph = new de.gaalop.clucalc.input.Plugin().createCodeParser().parseFile(this.inputStreamToInputFile(reader, "userMacros", f.getParentFile()));
                    reader.close();
                    MacrosVisitor.getAllMacros(userMacrosGraph, macros);
                } else {
                    System.err.println("Algebra Plugin: User Macro File Path does not exist!");
                }
            }
            RecursionChecker.check(graph, macros);
            Inliner.inline(graph, macros);
            LinkedList<AssignmentNode> toDelete = new LinkedList<AssignmentNode>();
            for (Macro macro : macros.values()) {
                graph.removeNode((SequentialNode)macro);
                for (SequentialNode n : macro.getBody()) {
                    for (AssignmentNode evalNode : graph.getOnlyEvaluateNodes()) {
                        if (n != evalNode) continue;
                        toDelete.add(evalNode);
                    }
                }
            }
            graph.getOnlyEvaluateNodes().removeAll(toDelete);
            for (AssignmentNode node : graph.getOnlyEvaluateNodes()) {
                graph.addPragmaOnlyEvaluateVariable(node.getVariable().getName());
            }
            BaseVectorDefiner definer = new BaseVectorDefiner();
            definer.createFromAlBase(alFile.base);
            BaseVectorReplaceVisitor replacerB = new BaseVectorReplaceVisitor(definer);
            graph.accept((ControlFlowVisitor)replacerB);
            UpdateLocalVariableSet.updateVariableSets(graph);
            HashMap<String[], Integer> indexByBlades = new HashMap<String[], Integer>();
            for (int index = 0; index < alFile.blades.length; ++index) {
                Expression expression = alFile.blades[index];
                List<String> blades = this.decomposeBlades(expression);
                indexByBlades.put(blades.toArray(new String[0]), index);
            }
            Set outputVariables = graph.getPragmaOutputVariables();
            HashSet outputVariablesCopy = new HashSet(outputVariables);
            outputVariables.clear();
            for (String outputVariable : outputVariablesCopy) {
                if (outputVariable.contains(" ")) {
                    String[] parts = outputVariable.split(" ");
                    if (parts[1].equals("1")) {
                        parts[1] = "1.0";
                    }
                    String variableText = parts[0];
                    String[] variables = AlStrategy.getVariables(variableText);
                    String bladeText = parts[1];
                    String[] currentBlades = bladeText.split("\\^");
                    boolean bladeFound = false;
                    for (String[] blades : indexByBlades.keySet()) {
                        if (!AlStrategy.areArraysEqual(currentBlades, blades)) continue;
                        int index = (Integer)indexByBlades.get(blades);
                        for (String variable : variables) {
                            outputVariables.add(variable + "$" + index);
                        }
                        bladeFound = true;
                        break;
                    }
                    if (bladeFound) continue;
                    throw new OptimizationException("The bladename " + bladeText + " is not found in the default blade list.", graph);
                }
                outputVariables.add(outputVariable);
            }
        }
        catch (CodeParserException ex) {
            Logger.getLogger(AlStrategy.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(AlStrategy.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException ex) {
                Logger.getLogger(AlStrategy.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public static String[] getVariables(String variableText) {
        if (variableText.startsWith("{") && variableText.endsWith("}")) {
            String innerText = variableText.substring(1, variableText.length() - 1);
            String[] variables = innerText.split(",");
            for (int i = 0; i < variables.length; ++i) {
                variables[i] = variables[i].trim();
            }
            return variables;
        }
        return new String[]{variableText};
    }

    public static boolean areArraysEqual(String[] array1, String[] array2) {
        if (array1.length != array2.length) {
            return false;
        }
        HashSet<String> set1 = new HashSet<String>(Arrays.asList(array1));
        HashSet<String> set2 = new HashSet<String>(Arrays.asList(array2));
        return set1.equals(set2);
    }

    private List<String> decomposeBlades(Expression blade) {
        if (!blade.isComposite()) {
            return Collections.singletonList(blade.toString());
        }
        OuterProduct outerProduct = (OuterProduct)blade;
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(this.decomposeBlades(outerProduct.getLeft()));
        list.addAll(this.decomposeBlades(outerProduct.getRight()));
        return list;
    }

    public static void createBlades(AlgebraDefinitionFile alFile) {
        TCBlade[] blades = BladeArrayRoutines.createBlades(Arrays.copyOfRange(alFile.base, 1, alFile.base.length));
        alFile.blades = new Expression[blades.length];
        for (int i = 0; i < blades.length; ++i) {
            alFile.blades[i] = blades[i].toExpression();
        }
        TCBlade[] blades2 = BladeArrayRoutines.createBlades(Arrays.copyOfRange(alFile.base2, 1, alFile.base2.length));
        alFile.blades2 = new Expression[blades2.length];
        for (int i = 0; i < blades2.length; ++i) {
            alFile.blades2[i] = blades2[i].toExpression();
        }
    }

    private InputFile inputStreamToInputFile(Reader reader, String cluName, File parent) {
        StringBuilder sb = new StringBuilder();
        this.readIn(reader, sb, parent);
        sb.append("\n");
        return new InputFile(cluName, sb.toString());
    }

    private void readIn(Reader reader, StringBuilder sb, File parent) {
        try {
            String line;
            BufferedReader bufReader = new BufferedReader(reader);
            while ((line = bufReader.readLine()) != null) {
                if (line.trim().startsWith("#include")) {
                    line = line.trim();
                    String filename = line.substring(line.indexOf(" ") + 1).trim();
                    File newParent = new File(parent, filename);
                    FileReader rea = new FileReader(newParent);
                    this.readIn(rea, sb, newParent);
                    rea.close();
                } else {
                    sb.append(line);
                }
                sb.append("\n");
            }
            bufReader.close();
        }
        catch (IOException ex) {
            Logger.getLogger(AlStrategy.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

