/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.algebra;

import de.gaalop.algebra.MacroVariablesDFGReplacer;
import de.gaalop.cfg.AssignmentNode;
import de.gaalop.cfg.BlockEndNode;
import de.gaalop.cfg.BreakNode;
import de.gaalop.cfg.ColorNode;
import de.gaalop.cfg.ControlFlowVisitor;
import de.gaalop.cfg.EndNode;
import de.gaalop.cfg.ExpressionStatement;
import de.gaalop.cfg.IfThenElseNode;
import de.gaalop.cfg.LoopNode;
import de.gaalop.cfg.Macro;
import de.gaalop.cfg.StartNode;
import de.gaalop.cfg.StoreResultNode;
import de.gaalop.dfg.Expression;
import de.gaalop.dfg.ExpressionVisitor;
import de.gaalop.dfg.Variable;
import java.util.HashMap;

public class MacroVariablesCFGReplacer
implements ControlFlowVisitor {
    private HashMap<String, Expression> replaceMap;
    private MacroVariablesDFGReplacer dfgReplacer;

    public MacroVariablesCFGReplacer(HashMap<String, Expression> replaceMap) {
        this.replaceMap = replaceMap;
        this.dfgReplacer = new MacroVariablesDFGReplacer(replaceMap);
    }

    public void visit(AssignmentNode node) {
        node.getValue().accept((ExpressionVisitor)this.dfgReplacer);
        if (this.dfgReplacer.result != null) {
            node.setValue(this.dfgReplacer.result);
            this.dfgReplacer.result = null;
        }
        if (this.replaceMap.containsKey(node.getVariable().getName())) {
            node.setVariable((Variable)this.replaceMap.get(node.getVariable().getName()).copy());
        }
    }

    public void visit(ExpressionStatement node) {
        node.getExpression().accept((ExpressionVisitor)this.dfgReplacer);
        if (this.dfgReplacer.result != null) {
            node.setExpression(this.dfgReplacer.result);
            this.dfgReplacer.result = null;
        }
    }

    public void visit(StoreResultNode node) {
        Expression replacement;
        if (this.replaceMap.containsKey(node.getValue().getName()) && (replacement = this.replaceMap.get(node.getValue().getName())) instanceof Variable) {
            node.setValue((Variable)replacement.copy());
        }
    }

    public void visit(StartNode node) {
        throw new IllegalStateException();
    }

    public void visit(IfThenElseNode node) {
        throw new IllegalStateException();
    }

    public void visit(BlockEndNode node) {
        throw new IllegalStateException();
    }

    public void visit(LoopNode node) {
        throw new IllegalStateException();
    }

    public void visit(BreakNode node) {
        throw new IllegalStateException();
    }

    public void visit(Macro node) {
        throw new IllegalStateException();
    }

    public void visit(EndNode node) {
        throw new IllegalStateException();
    }

    public void visit(ColorNode node) {
        throw new IllegalStateException();
    }
}

