/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.algebra;

import de.gaalop.dfg.Expression;
import de.gaalop.dfg.ExpressionVisitor;
import de.gaalop.dfg.FunctionArgument;
import de.gaalop.dfg.MacroCall;
import de.gaalop.dfg.Variable;
import de.gaalop.visitors.ReplaceVisitor;
import java.util.ArrayList;
import java.util.HashMap;

public class MacroVariablesDFGReplacer
extends ReplaceVisitor {
    private HashMap<String, Expression> replaceMap;

    public MacroVariablesDFGReplacer(HashMap<String, Expression> replaceMap) {
        this.replaceMap = replaceMap;
    }

    public void visit(Variable node) {
        if (this.replaceMap.containsKey(node.getName())) {
            this.result = this.replaceMap.get(node.getName()).copy();
        }
        super.visit(node);
    }

    public void visit(FunctionArgument node) {
        this.result = this.replaceMap.get("_P(" + node.getIndex() + ")");
    }

    public void visit(MacroCall node) {
        ArrayList<Expression> newArgs = new ArrayList<Expression>(node.getArguments().size());
        for (Expression arg : node.getArguments()) {
            arg.accept((ExpressionVisitor)this);
            if (this.result == null) {
                newArgs.add(arg);
                continue;
            }
            newArgs.add(this.result);
            this.result = null;
        }
        node.setArgs(newArgs);
    }
}

