/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.algebra;

import de.gaalop.algebra.MaxFunctionArgumentNumberGetter;
import de.gaalop.algebra.StringIntContainer;
import de.gaalop.cfg.AssignmentNode;
import de.gaalop.cfg.ControlFlowGraph;
import de.gaalop.cfg.ControlFlowVisitor;
import de.gaalop.cfg.EmptyControlFlowVisitor;
import de.gaalop.cfg.Macro;
import de.gaalop.cfg.SequentialNode;
import de.gaalop.dfg.Expression;
import java.util.HashMap;
import java.util.List;

public class MacrosVisitor
extends EmptyControlFlowVisitor {
    private HashMap<StringIntContainer, Macro> macrosMap;

    private MacrosVisitor() {
    }

    public static HashMap<StringIntContainer, Macro> getAllMacros(ControlFlowGraph graph) {
        MacrosVisitor visitor = new MacrosVisitor();
        visitor.macrosMap = new HashMap();
        graph.accept((ControlFlowVisitor)visitor);
        return visitor.macrosMap;
    }

    public static void getAllMacros(ControlFlowGraph graph, HashMap<StringIntContainer, Macro> mapToUse) {
        MacrosVisitor visitor = new MacrosVisitor();
        visitor.macrosMap = mapToUse;
        graph.accept((ControlFlowVisitor)visitor);
    }

    private int getMaxCountOfUsedArguments(List<SequentialNode> body) {
        int max = 0;
        for (SequentialNode node : body) {
            if (!(node instanceof AssignmentNode)) continue;
            AssignmentNode aNode = (AssignmentNode)node;
            max = Math.max(max, MaxFunctionArgumentNumberGetter.getMaxFunctionArgumentNumber((Expression)aNode.getVariable()));
            max = Math.max(max, MaxFunctionArgumentNumberGetter.getMaxFunctionArgumentNumber(aNode.getValue()));
        }
        return max;
    }

    public void visit(Macro node) {
        int argsCount = Math.max(this.getMaxCountOfUsedArguments(node.getBody()), MaxFunctionArgumentNumberGetter.getMaxFunctionArgumentNumber(node.getReturnValue()));
        this.macrosMap.put(new StringIntContainer(node.getName(), argsCount), node);
        super.visit(node);
    }
}

