/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.algebra;

import de.gaalop.AlgebraStrategy;
import de.gaalop.AlgebraStrategyPlugin;
import de.gaalop.ConfigurationProperty;
import de.gaalop.Notifications;
import de.gaalop.algebra.AlStrategy;
import de.gaalop.algebra.DefinedAlgebra;
import java.awt.Image;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.Observable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;

public class Plugin
extends Observable
implements AlgebraStrategyPlugin {
    @ConfigurationProperty(type=ConfigurationProperty.Type.BOOLEAN)
    public boolean usePrecalulatedTables = true;
    @ConfigurationProperty(type=ConfigurationProperty.Type.DIRPATH)
    public String additionalBaseDirectory = "";
    @ConfigurationProperty(type=ConfigurationProperty.Type.FILEPATH)
    public String userMacroFilePath = "";
    public String algebraDefinitionString = null;
    public String macroDefinitionString = null;
    public boolean atLeastOneQuestionSignedRequired = true;

    public AlgebraStrategy createAlgebraStrategy() {
        return new AlStrategy(this);
    }

    public String getName() {
        return "Algebra";
    }

    public String getDescription() {
        return "This plugin sets the algebra for the graph and replaces all functions that are algebra-depend.";
    }

    public Image getIcon() {
        return null;
    }

    void notifyError(Throwable error) {
        this.setChanged();
        this.notifyObservers(new Notifications.Error(error));
    }

    public boolean isUsePrecalulatedTables() {
        return this.usePrecalulatedTables;
    }

    public String getUserMacroFilePath() {
        return this.userMacroFilePath;
    }

    public void setUserMacroFilePath(String userMacroFilePath) {
        this.userMacroFilePath = userMacroFilePath;
    }

    public void setUsePrecalulatedTables(boolean usePrecalulatedTables) {
        this.usePrecalulatedTables = usePrecalulatedTables;
    }

    public String getAdditionalBaseDirectory() {
        return this.additionalBaseDirectory;
    }

    public void setAdditionalBaseDirectory(String additionalBaseDirectory) {
        this.additionalBaseDirectory = additionalBaseDirectory;
    }

    public static LinkedList<DefinedAlgebra> getDefinedAlgebras() {
        try {
            LinkedList<DefinedAlgebra> result = new LinkedList<DefinedAlgebra>();
            for (String line : IOUtils.toString((InputStream)Plugin.class.getResourceAsStream("algebra/definedAlgebras.txt"), (String)"UTF-8").split("\r\n")) {
                String[] parts = line.split(";");
                if (parts.length != 2) continue;
                result.add(new DefinedAlgebra(parts[0], parts[1]));
            }
            return result;
        }
        catch (IOException ex) {
            Logger.getLogger(Plugin.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }
}

