/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.algebra;

import de.gaalop.OptimizationException;
import de.gaalop.algebra.StringIntContainer;
import de.gaalop.cfg.AssignmentNode;
import de.gaalop.cfg.BlockEndNode;
import de.gaalop.cfg.BreakNode;
import de.gaalop.cfg.ColorNode;
import de.gaalop.cfg.ControlFlowGraph;
import de.gaalop.cfg.ControlFlowVisitor;
import de.gaalop.cfg.EndNode;
import de.gaalop.cfg.ExpressionStatement;
import de.gaalop.cfg.IfThenElseNode;
import de.gaalop.cfg.LoopNode;
import de.gaalop.cfg.Macro;
import de.gaalop.cfg.SequentialNode;
import de.gaalop.cfg.StartNode;
import de.gaalop.cfg.StoreResultNode;
import de.gaalop.dfg.ExpressionVisitor;
import de.gaalop.dfg.MacroCall;
import de.gaalop.visitors.DFGTraversalVisitor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;

public class RecursionChecker {
    private final ControlFlowGraph graph;
    private final HashMap<StringIntContainer, Macro> macros;
    private final HashSet<StringIntContainer> curContainers = new HashSet();

    private RecursionChecker(ControlFlowGraph graph, HashMap<StringIntContainer, Macro> macros) {
        this.graph = graph;
        this.macros = macros;
    }

    public static void check(ControlFlowGraph graph, HashMap<StringIntContainer, Macro> macros) throws OptimizationException {
        RecursionChecker checker = new RecursionChecker(graph, macros);
        for (StringIntContainer container : macros.keySet()) {
            checker.curContainers.clear();
            checker.checkContainer(container);
        }
    }

    private void checkContainer(StringIntContainer container) throws OptimizationException {
        if (this.curContainers.contains(container)) {
            throw new OptimizationException("Macro " + container.getName() + "(with " + container.getNumber() + " parameters) contains a recursion. Please remove the recursion!", this.graph);
        }
        this.curContainers.add(container);
        Macro macro = this.macros.get(container);
        if (macro != null) {
            MacroCallCollector collector = new MacroCallCollector();
            for (SequentialNode node : macro.getBody()) {
                node.accept((ControlFlowVisitor)collector);
            }
            for (StringIntContainer child : collector.macroCalls) {
                this.checkContainer(child);
            }
        }
        this.curContainers.remove(container);
    }

    private class MacroCallCollector
    extends DFGTraversalVisitor
    implements ControlFlowVisitor {
        public LinkedList<StringIntContainer> macroCalls = new LinkedList();

        private MacroCallCollector() {
        }

        public void visit(MacroCall macroExpr) {
            this.macroCalls.add(new StringIntContainer(macroExpr.getName(), macroExpr.getArguments().size()));
        }

        public void visit(AssignmentNode node) {
            node.getValue().accept((ExpressionVisitor)this);
        }

        public void visit(ExpressionStatement node) {
            node.getExpression().accept((ExpressionVisitor)this);
        }

        public void visit(ColorNode node) {
            node.getR().accept((ExpressionVisitor)this);
            node.getG().accept((ExpressionVisitor)this);
            node.getB().accept((ExpressionVisitor)this);
            node.getAlpha().accept((ExpressionVisitor)this);
        }

        public void visit(StartNode node) {
        }

        public void visit(StoreResultNode node) {
        }

        public void visit(IfThenElseNode node) {
        }

        public void visit(BlockEndNode node) {
        }

        public void visit(LoopNode node) {
        }

        public void visit(BreakNode node) {
        }

        public void visit(Macro node) {
        }

        public void visit(EndNode node) {
        }
    }
}

