/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.algebra;

import de.gaalop.dfg.BaseVector;
import de.gaalop.dfg.Expression;
import de.gaalop.dfg.FloatConstant;
import de.gaalop.dfg.OuterProduct;
import java.util.Arrays;

public class TCBlade {
    private String[] base;

    public TCBlade(String[] base) {
        this.base = base;
    }

    public String[] getBase() {
        return this.base;
    }

    public void setBase(String[] base) {
        this.base = base;
    }

    public Expression toExpression() {
        if (this.base.length == 1 && this.base[0].equals("1")) {
            return new FloatConstant(1.0);
        }
        Expression[] exprArr = new Expression[this.base.length];
        for (int i = 0; i < exprArr.length; ++i) {
            exprArr[i] = new BaseVector(this.base[i].substring(1));
        }
        return TCBlade.exprArrToOuterProduct(exprArr);
    }

    public static Expression exprArrToOuterProduct(Expression[] arr) {
        OuterProduct r;
        if (arr.length == 1) {
            return arr[0];
        }
        OuterProduct cur = r = new OuterProduct(arr[0], null);
        for (int i = 1; i < arr.length - 1; ++i) {
            OuterProduct add = new OuterProduct(arr[i], null);
            cur.setRight((Expression)add);
            cur = add;
        }
        cur.setRight(arr[arr.length - 1]);
        return r;
    }

    public boolean equals(Object obj) {
        if (obj instanceof TCBlade) {
            TCBlade comp = (TCBlade)obj;
            return Arrays.equals(comp.base, this.base);
        }
        return false;
    }
}

