/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.algebra;

import de.gaalop.cfg.AssignmentNode;
import de.gaalop.cfg.ControlFlowGraph;
import de.gaalop.cfg.ControlFlowVisitor;
import de.gaalop.cfg.EmptyControlFlowVisitor;
import de.gaalop.dfg.ExpressionVisitor;
import de.gaalop.dfg.MultivectorComponent;
import de.gaalop.dfg.Variable;
import de.gaalop.visitors.DFGTraversalVisitor;
import java.util.HashSet;
import java.util.LinkedList;

public class UpdateLocalVariableSet
extends EmptyControlFlowVisitor {
    private HashSet<String> inputVariables = new HashSet();
    private HashSet<String> defined = new HashSet();
    private HashSet<String> scalarVariables = new HashSet();
    private DFGTraversalVisitor dfgVisitor = new DFGTraversalVisitor(){

        public void visit(Variable node) {
            if (!UpdateLocalVariableSet.this.defined.contains(node.getName()) && !UpdateLocalVariableSet.this.scalarVariables.contains(node.getName())) {
                UpdateLocalVariableSet.this.inputVariables.add(node.getName());
            }
            super.visit(node);
        }

        public void visit(MultivectorComponent node) {
            if (!UpdateLocalVariableSet.this.defined.contains(node.getName()) && !UpdateLocalVariableSet.this.scalarVariables.contains(node.getName())) {
                UpdateLocalVariableSet.this.inputVariables.add(node.getName());
            }
            super.visit(node);
        }
    };

    private UpdateLocalVariableSet() {
    }

    public void visit(AssignmentNode node) {
        node.getValue().accept((ExpressionVisitor)this.dfgVisitor);
        if (node.getVariable() instanceof MultivectorComponent) {
            this.defined.add(node.getVariable().getName());
        } else {
            this.scalarVariables.add(node.getVariable().getName());
        }
        super.visit(node);
    }

    public static void updateVariableSets(ControlFlowGraph graph) {
        UpdateLocalVariableSet visitor = new UpdateLocalVariableSet();
        graph.accept((ControlFlowVisitor)visitor);
        LinkedList inputVarList = new LinkedList(graph.getInputVariables());
        LinkedList localVarList = new LinkedList(graph.getLocalVariables());
        LinkedList scalarVarList = new LinkedList(graph.getScalarVariables());
        for (Variable variable : inputVarList) {
            graph.removeInputVariable(variable);
        }
        for (Variable variable : localVarList) {
            graph.removeLocalVariable(variable);
        }
        for (Variable variable : scalarVarList) {
            graph.removeScalarVariable(variable);
        }
        for (String string : visitor.inputVariables) {
            graph.addInputVariable(new Variable(string));
        }
        for (String string : visitor.defined) {
            graph.addLocalVariable(new Variable(string));
        }
        for (String string : visitor.scalarVariables) {
            graph.addScalarVariable(new Variable(string));
        }
    }
}

