/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.java;

import de.gaalop.OperatorPriority;
import de.gaalop.cfg.AssignmentNode;
import de.gaalop.cfg.BlockEndNode;
import de.gaalop.cfg.BreakNode;
import de.gaalop.cfg.ColorNode;
import de.gaalop.cfg.ControlFlowGraph;
import de.gaalop.cfg.ControlFlowVisitor;
import de.gaalop.cfg.EndNode;
import de.gaalop.cfg.ExpressionStatement;
import de.gaalop.cfg.IfThenElseNode;
import de.gaalop.cfg.LoopNode;
import de.gaalop.cfg.Macro;
import de.gaalop.cfg.StartNode;
import de.gaalop.cfg.StoreResultNode;
import de.gaalop.dfg.Addition;
import de.gaalop.dfg.BaseVector;
import de.gaalop.dfg.BinaryOperation;
import de.gaalop.dfg.Division;
import de.gaalop.dfg.Equality;
import de.gaalop.dfg.Exponentiation;
import de.gaalop.dfg.Expression;
import de.gaalop.dfg.ExpressionVisitor;
import de.gaalop.dfg.FloatConstant;
import de.gaalop.dfg.FunctionArgument;
import de.gaalop.dfg.Inequality;
import de.gaalop.dfg.InnerProduct;
import de.gaalop.dfg.LogicalAnd;
import de.gaalop.dfg.LogicalNegation;
import de.gaalop.dfg.LogicalOr;
import de.gaalop.dfg.MacroCall;
import de.gaalop.dfg.MathFunction;
import de.gaalop.dfg.MathFunctionCall;
import de.gaalop.dfg.Multiplication;
import de.gaalop.dfg.MultivectorComponent;
import de.gaalop.dfg.Negation;
import de.gaalop.dfg.OuterProduct;
import de.gaalop.dfg.Relation;
import de.gaalop.dfg.Reverse;
import de.gaalop.dfg.Subtraction;
import de.gaalop.dfg.Variable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JavaVisitor
implements ControlFlowVisitor,
ExpressionVisitor {
    public String filename;
    protected Log log = LogFactory.getLog(JavaVisitor.class);
    protected StringBuilder codePre = new StringBuilder();
    protected StringBuilder codeCalc = new StringBuilder();
    protected StringBuilder codePost = new StringBuilder();
    protected ControlFlowGraph graph;
    protected int indentation = 0;
    protected OperatorPriority operatorPriority = new OperatorPriority();
    protected Set<String> declaredLocal = new HashSet<String>();
    protected Set<String> outputtedMultivectors = new HashSet<String>();
    private final int JAVALIMIT = 65500;
    private byte curSection = 0;
    private boolean implementFactorial = false;

    private void append(char character) {
        this.append(character + "");
    }

    private void append(String string) {
        switch (this.curSection) {
            case 0: {
                this.codePre.append(string);
                break;
            }
            case 1: {
                this.codeCalc.append(string);
                break;
            }
            case 2: {
                this.codePost.append(string);
            }
        }
    }

    public String getCode() {
        StringBuilder result = new StringBuilder();
        result.append((CharSequence)this.codePre);
        if (this.codeCalc.length() > 65500) {
            result.append(this.splitUpCalcMethods());
        } else {
            result.append((CharSequence)this.codeCalc);
        }
        result.append((CharSequence)this.codePost);
        return result.toString();
    }

    protected void appendIndentation() {
        for (int i = 0; i < this.indentation; ++i) {
            this.append('\t');
        }
    }

    public void visit(StartNode node) {
        this.graph = node.getGraph();
        this.curSection = 0;
        this.implementFactorial = false;
        this.append("import java.util.HashMap;\n\n");
        int lastDotIndex = this.filename.lastIndexOf(46);
        if (lastDotIndex != -1) {
            this.filename = this.filename.substring(0, lastDotIndex);
        }
        this.append("public class " + this.filename + " implements GAProgram {\n");
        ++this.indentation;
        ++this.indentation;
        this.appendIndentation();
        this.curSection = 1;
        node.getSuccessor().accept((ControlFlowVisitor)this);
    }

    protected List<Variable> sortVariables(Set<Variable> inputVariables) {
        ArrayList<Variable> variables = new ArrayList<Variable>(inputVariables);
        Comparator<Variable> comparator = new Comparator<Variable>(){

            @Override
            public int compare(Variable o1, Variable o2) {
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        };
        Collections.sort(variables, comparator);
        return variables;
    }

    private String getVarName(Variable var) {
        if (!(var instanceof MultivectorComponent)) {
            return var.getName() + "$0";
        }
        return var.getName() + "$" + ((MultivectorComponent)var).getBladeIndex();
    }

    public void visit(AssignmentNode node) {
        this.appendIndentation();
        this.declaredLocal.add(this.getVarName(node.getVariable()));
        node.getVariable().accept((ExpressionVisitor)this);
        this.append(" = ");
        node.getValue().accept((ExpressionVisitor)this);
        if (node.getVariable() instanceof MultivectorComponent) {
            this.append(';');
            this.append(" // ");
            this.append(node.getGraph().getBladeString((MultivectorComponent)node.getVariable()));
        }
        this.append(";\n");
        node.getSuccessor().accept((ControlFlowVisitor)this);
    }

    public void visit(ExpressionStatement node) {
        this.appendIndentation();
        node.getExpression().accept((ExpressionVisitor)this);
        this.append(";\n");
        node.getSuccessor().accept((ControlFlowVisitor)this);
    }

    public void visit(StoreResultNode node) {
        this.outputtedMultivectors.add(node.getValue().getName());
        node.getSuccessor().accept((ControlFlowVisitor)this);
    }

    public void visit(IfThenElseNode node) {
        Expression condition = node.getCondition();
        this.appendIndentation();
        this.append("if (");
        condition.accept((ExpressionVisitor)this);
        this.append(") {\n");
        ++this.indentation;
        node.getPositive().accept((ControlFlowVisitor)this);
        --this.indentation;
        this.appendIndentation();
        this.append("}");
        if (node.getNegative() instanceof BlockEndNode) {
            this.append("\n");
        } else {
            this.append(" else ");
            boolean isElseIf = false;
            if (node.getNegative() instanceof IfThenElseNode) {
                IfThenElseNode ifthenelse = (IfThenElseNode)node.getNegative();
                isElseIf = ifthenelse.isElseIf();
            }
            if (!isElseIf) {
                this.append("{\n");
                ++this.indentation;
            }
            node.getNegative().accept((ControlFlowVisitor)this);
            if (!isElseIf) {
                --this.indentation;
                this.appendIndentation();
                this.append("}\n");
            }
        }
        node.getSuccessor().accept((ControlFlowVisitor)this);
    }

    public void visit(LoopNode node) {
        this.appendIndentation();
        this.append("while(true) {\n");
        ++this.indentation;
        node.getBody().accept((ControlFlowVisitor)this);
        --this.indentation;
        this.appendIndentation();
        this.append("}\n");
        node.getSuccessor().accept((ControlFlowVisitor)this);
    }

    public void visit(BreakNode breakNode) {
        this.appendIndentation();
        this.append("break;\n");
    }

    public void visit(BlockEndNode node) {
    }

    public void visit(EndNode node) {
        --this.indentation;
        this.appendIndentation();
        this.append("}\n\n");
        this.curSection = (byte)2;
        --this.indentation;
        if (this.implementFactorial) {
            this.appendIndentation();
            this.append("private double fact(int n) {\n");
            ++this.indentation;
            this.appendIndentation();
            this.append("double result = 1;\n");
            this.appendIndentation();
            this.append("for (int i=2;i<=n;i++)\n");
            ++this.indentation;
            this.appendIndentation();
            this.append("result *= i;\n");
            --this.indentation;
            this.appendIndentation();
            this.append("return result;\n");
            --this.indentation;
            this.appendIndentation();
            this.append("}\n");
        }
        this.append("\n");
        --this.indentation;
        this.appendIndentation();
        this.append("}\n");
        this.curSection = 0;
        this.append("\n");
        ++this.indentation;
        ++this.indentation;
        this.appendIndentation();
        this.append("// input variables\n");
        for (Variable inputVar : this.graph.getInputVariables()) {
            this.appendIndentation();
            this.append("private double " + this.getVarName(inputVar) + ";\n");
        }
        this.append("\n");
        LinkedList<String> locals = new LinkedList<String>();
        LinkedList<String> outputs = new LinkedList<String>();
        for (String l : this.declaredLocal) {
            String name = l.split("\\$")[0];
            if (this.outputtedMultivectors.contains(name)) {
                int outputComponentExist = 0;
                for (String outputVarStr : this.graph.getPragmaOutputVariables()) {
                    if (!outputVarStr.split("\\$")[0].equals(name)) continue;
                    outputComponentExist = 1;
                }
                if (outputComponentExist != 0) {
                    if (this.graph.getPragmaOutputVariables().contains(l)) {
                        outputs.add(l);
                        continue;
                    }
                    locals.add(l);
                    continue;
                }
                outputs.add(l);
                continue;
            }
            locals.add(l);
        }
        Object[] localsArr = locals.toArray(new String[0]);
        Object[] outputsArr = outputs.toArray(new String[0]);
        Arrays.sort(localsArr);
        Arrays.sort(outputsArr);
        this.appendIndentation();
        this.append("// local variables\n");
        for (Object curLocal : localsArr) {
            this.appendIndentation();
            this.append("private double " + (String)curLocal + ";\n");
        }
        this.append("\n");
        this.appendIndentation();
        this.append("// output variables\n");
        for (Object curOutput : outputsArr) {
            this.appendIndentation();
            this.append("private double " + (String)curOutput + ";\n");
        }
        this.append("\n");
        this.appendIndentation();
        this.append("@Override\n");
        this.appendIndentation();
        this.append("public double getValue(String varName) {\n");
        ++this.indentation;
        for (String curOutput : outputs) {
            this.appendIndentation();
            this.append("if (varName.equals(\"" + curOutput + "\")) return " + curOutput + ";\n");
        }
        this.appendIndentation();
        this.append("return 0.0d;\n");
        --this.indentation;
        this.appendIndentation();
        this.append("}\n");
        this.append("\n");
        this.appendIndentation();
        this.append("@Override\n");
        this.appendIndentation();
        this.append("public HashMap<String,Double> getValues() {\n");
        ++this.indentation;
        this.appendIndentation();
        this.append("HashMap<String,Double> result = new HashMap<String,Double>();\n");
        for (String curOutput : outputs) {
            this.appendIndentation();
            this.append("result.put(\"" + curOutput + "\"," + curOutput + ");\n");
        }
        this.appendIndentation();
        this.append("return result;\n");
        --this.indentation;
        this.appendIndentation();
        this.append("}\n");
        this.appendIndentation();
        this.append("@Override\n");
        this.appendIndentation();
        this.append("public boolean setValue(String varName, double value) {\n");
        ++this.indentation;
        for (Variable inputVar : this.graph.getInputVariables()) {
            this.appendIndentation();
            this.append("if (varName.equals(\"" + this.getVarName(inputVar) + "\")) { " + this.getVarName(inputVar) + " = value; return true; }\n");
        }
        this.appendIndentation();
        this.append("return false;\n");
        --this.indentation;
        this.appendIndentation();
        this.append("}\n");
        this.appendIndentation();
        this.append("\n");
        this.appendIndentation();
        this.append("@Override\n");
        this.appendIndentation();
        this.append("public void calculate() {\n");
        ++this.indentation;
        this.curSection = (byte)2;
    }

    public void visit(ColorNode node) {
        node.getSuccessor().accept((ControlFlowVisitor)this);
    }

    protected void addBinaryInfix(BinaryOperation op, String operator) {
        this.append("(");
        this.addChild((Expression)op, op.getLeft());
        this.append(operator);
        this.addChild((Expression)op, op.getRight());
        this.append(")");
    }

    protected void addChild(Expression parent, Expression child) {
        if (this.operatorPriority.hasLowerPriority(parent, child)) {
            this.append('(');
            child.accept((ExpressionVisitor)this);
            this.append(')');
        } else {
            child.accept((ExpressionVisitor)this);
        }
    }

    public void visit(Subtraction subtraction) {
        this.addBinaryInfix((BinaryOperation)subtraction, " - ");
    }

    public void visit(Addition addition) {
        this.addBinaryInfix((BinaryOperation)addition, " + ");
    }

    public void visit(Division division) {
        this.addBinaryInfix((BinaryOperation)division, " / ");
    }

    public void visit(InnerProduct innerProduct) {
        throw new UnsupportedOperationException("The Java backend does not support the inner product.");
    }

    public void visit(Multiplication multiplication) {
        this.addBinaryInfix((BinaryOperation)multiplication, " * ");
    }

    public void visit(MathFunctionCall mathFunctionCall) {
        String funcName = "(double) Math." + mathFunctionCall.getFunction().toString().toLowerCase();
        if (mathFunctionCall.getFunction() == MathFunction.FACT) {
            funcName = "fact";
            this.implementFactorial = true;
        }
        this.append(funcName);
        this.append('(');
        mathFunctionCall.getOperand().accept((ExpressionVisitor)this);
        this.append(')');
    }

    public void visit(Variable variable) {
        this.append(this.getVarName(variable));
    }

    public void visit(MultivectorComponent component) {
        this.append(this.getVarName((Variable)component));
    }

    public void visit(Exponentiation exponentiation) {
        if (this.isSquare(exponentiation)) {
            Multiplication m = new Multiplication(exponentiation.getLeft(), exponentiation.getLeft());
            m.accept((ExpressionVisitor)this);
        } else {
            this.append("Math.pow(");
            exponentiation.getLeft().accept((ExpressionVisitor)this);
            this.append(',');
            exponentiation.getRight().accept((ExpressionVisitor)this);
            this.append(')');
        }
    }

    protected boolean isSquare(Exponentiation exponentiation) {
        FloatConstant two = new FloatConstant(2.0);
        return two.equals((Object)exponentiation.getRight());
    }

    public void visit(FloatConstant floatConstant) {
        this.append(Double.toString(floatConstant.getValue()));
        this.append('d');
    }

    public void visit(OuterProduct outerProduct) {
        throw new UnsupportedOperationException("The Java backend does not support the outer product.");
    }

    public void visit(BaseVector baseVector) {
        throw new UnsupportedOperationException("The Java backend does not support base vectors.");
    }

    public void visit(Negation negation) {
        this.append("(-");
        this.addChild((Expression)negation, negation.getOperand());
        this.append(")");
    }

    public void visit(Reverse node) {
        throw new UnsupportedOperationException("The Java backend does not support the reverse operation.");
    }

    public void visit(LogicalOr node) {
        this.addBinaryInfix((BinaryOperation)node, " || ");
    }

    public void visit(LogicalAnd node) {
        this.addBinaryInfix((BinaryOperation)node, " && ");
    }

    public void visit(LogicalNegation node) {
        this.append('!');
        this.addChild((Expression)node, node.getOperand());
    }

    public void visit(Equality node) {
        this.addBinaryInfix((BinaryOperation)node, " == ");
    }

    public void visit(Inequality node) {
        this.addBinaryInfix((BinaryOperation)node, " != ");
    }

    public void visit(Relation relation) {
        this.addBinaryInfix((BinaryOperation)relation, relation.getTypeString());
    }

    public void visit(Macro node) {
        throw new IllegalStateException("Macros should have been inlined and removed from the graph.");
    }

    public void visit(FunctionArgument node) {
        throw new IllegalStateException("Macros should have been inlined and no function arguments should be the graph.");
    }

    public void visit(MacroCall node) {
        throw new IllegalStateException("Macros should have been inlined and no macro calls should be in the graph.");
    }

    private String splitUpCalcMethods() {
        StringBuilder result = new StringBuilder();
        int backupIndentation = this.indentation;
        int length = this.codeCalc.length();
        int curPosition = 0;
        int curProcCounter = 1;
        while (length - curPosition > 65500) {
            String part = this.codeCalc.substring(curPosition, curPosition + 65500);
            int lastSemicolon = part.lastIndexOf(10);
            if (lastSemicolon > 0) {
                int i;
                curPosition += lastSemicolon + 1;
                result.append(part.substring(0, lastSemicolon + 1));
                for (i = 0; i < this.indentation; ++i) {
                    result.append('\t');
                }
                result.append("calculate" + curProcCounter + "();\n");
                --this.indentation;
                for (i = 0; i < this.indentation; ++i) {
                    result.append('\t');
                }
                result.append("}\n\n");
                for (i = 0; i < this.indentation; ++i) {
                    result.append('\t');
                }
                result.append("public void calculate" + curProcCounter + "() {\n");
                ++this.indentation;
                ++curProcCounter;
                continue;
            }
            System.err.println("Expression is more than 65500 chars long. The outputted file is not compilable with code limit of java! Try to split the calculate method manually!");
            break;
        }
        result.append(this.codeCalc.substring(curPosition));
        this.indentation = backupIndentation;
        return result.toString();
    }
}

