/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.gaalet;

import de.gaalop.CodeParser;
import de.gaalop.CodeParserException;
import de.gaalop.InputFile;
import de.gaalop.cfg.ControlFlowGraph;
import de.gaalop.gaalet.Plugin;
import de.gaalop.gaalet.antlr.GaaletLexer;
import de.gaalop.gaalet.antlr.GaaletParser;
import de.gaalop.gaalet.antlr.GaaletTransformer;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTreeNodeStream;
import org.antlr.runtime.tree.TreeNodeStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public enum GaaletCodeParser implements CodeParser
{
    INSTANCE;

    private static final Log log;
    private Plugin plugin;

    public void setPluginReference(Plugin plugin) {
        if (this.plugin == null) {
            this.plugin = plugin;
        }
    }

    public ControlFlowGraph parseFile(InputFile input) throws CodeParserException {
        ControlFlowGraph graph;
        log.debug((Object)("Processing" + input.getName() + ", Content: " + input.getContent()));
        try {
            graph = this.parse(input);
        }
        catch (Throwable e) {
            throw new CodeParserException(input, "Unable to parse Gaalet file.\n" + e.getMessage(), e);
        }
        graph.setSource(input);
        return graph;
    }

    private ControlFlowGraph parse(InputFile input) throws CodeParserException, RecognitionException {
        ANTLRStringStream inputStream = new ANTLRStringStream(input.getContent());
        GaaletLexer lexer = new GaaletLexer((CharStream)inputStream);
        CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
        GaaletParser parser = new GaaletParser((TokenStream)tokenStream);
        GaaletParser.script_return parserResult = parser.script();
        if (!parser.getErrors().isEmpty()) {
            StringBuilder message = new StringBuilder();
            message.append("Unable to parse Gaalet file:\n");
            for (String error : parser.getErrors()) {
                message.append(error);
                message.append('\n');
            }
            throw new CodeParserException(input, message.toString());
        }
        if (parserResult.getTree() == null) {
            throw new CodeParserException(input, "The input file is empty.");
        }
        CommonTreeNodeStream treeNodeStream = new CommonTreeNodeStream(parserResult.getTree());
        GaaletTransformer transformer = new GaaletTransformer((TreeNodeStream)treeNodeStream);
        ControlFlowGraph graph = transformer.script();
        if (!parser.getErrors().isEmpty()) {
            StringBuilder message = new StringBuilder();
            message.append("Unable to parse Gaalet file:\n");
            for (String error : parser.getErrors()) {
                message.append(error);
                message.append('\n');
            }
            throw new CodeParserException(input, message.toString());
        }
        return graph;
    }

    static {
        log = LogFactory.getLog(GaaletCodeParser.class);
    }
}

