/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.gaalet;

import de.gaalop.CheckGAVisitor;
import de.gaalop.NameTable;
import de.gaalop.UsedVariablesVisitor;
import de.gaalop.cfg.AssignmentNode;
import de.gaalop.cfg.BlockEndNode;
import de.gaalop.cfg.BreakNode;
import de.gaalop.cfg.ColorNode;
import de.gaalop.cfg.ControlFlowGraph;
import de.gaalop.cfg.ControlFlowVisitor;
import de.gaalop.cfg.EndNode;
import de.gaalop.cfg.ExpressionStatement;
import de.gaalop.cfg.IfThenElseNode;
import de.gaalop.cfg.LoopNode;
import de.gaalop.cfg.Macro;
import de.gaalop.cfg.Node;
import de.gaalop.cfg.SequentialNode;
import de.gaalop.cfg.SetCallerVisitor;
import de.gaalop.cfg.StartNode;
import de.gaalop.cfg.StoreResultNode;
import de.gaalop.cfg.VariableScope;
import de.gaalop.dfg.Expression;
import de.gaalop.dfg.ExpressionVisitor;
import de.gaalop.dfg.MacroCall;
import de.gaalop.dfg.MultivectorComponent;
import de.gaalop.dfg.Variable;
import de.gaalop.gaalet.GaaletMultiVector;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class GraphBuilder {
    private final ControlFlowGraph graph;
    private SequentialNode lastNode;
    private HashMap<String, GaaletMultiVector> vectorSet = new HashMap();
    private int assignments;
    private Set<String> macros = new HashSet<String>();
    private String currentMacroDefinition;
    private VariableScope currentScope = VariableScope.GLOBAL;
    private static final Map<String, String> illegalNames = new HashMap<String, String>();

    public GraphBuilder() {
        this.graph = new ControlFlowGraph();
        this.lastNode = this.graph.getStartNode();
    }

    void checkIllegalVariable(Variable variable) {
        String name = variable.getName();
        String reason = illegalNames.get(name);
        if (reason != null) {
            throw new IllegalArgumentException("Illegal variable name '" + name + "' (" + reason + "). Please use another variable.");
        }
        if (variable.getName().startsWith("condition_")) {
            throw new IllegalArgumentException("Variable '" + variable + "' cannot be used because of prefix 'condition_' which is used for conditional statements. Please choose another name.");
        }
    }

    public void beginNewScope() {
        this.currentScope = new VariableScope(this.currentScope);
    }

    public void endNewScope() {
        this.currentScope = this.currentScope.getParent();
    }

    public void addPragmaOutputVariable(String variable) {
        this.graph.addPragmaOutputVariable(variable);
    }

    public void addPragmaMinMaxValues(String variable, String min, String max) {
        this.graph.addPragmaMinMaxValues(variable, min, max);
    }

    private void addNode(SequentialNode node) {
        this.lastNode.insertAfter(node);
        this.lastNode = node;
    }

    public void addIgnoreVariable(Variable variable) {
        this.graph.addScalarVariable(variable);
    }

    public ExpressionStatement processExpressionStatement(Expression e) {
        ExpressionStatement statement = new ExpressionStatement(this.graph, e);
        this.addNode((SequentialNode)statement);
        return statement;
    }

    public ControlFlowGraph getGraph() {
        return this.graph;
    }

    public LoopNode handleLoop(List<SequentialNode> body, String iterations, Variable counter) {
        LoopNode loop = new LoopNode(this.graph);
        this.addNode((SequentialNode)loop);
        this.rewireNodes(body, (SequentialNode)loop);
        loop.setBody((SequentialNode)(body != null && body.size() > 0 ? body.get(0) : new BlockEndNode(this.graph, (SequentialNode)loop)));
        if (iterations != null) {
            loop.setIterations(Integer.parseInt(iterations));
        }
        if (counter != null) {
            if (CheckGAVisitor.isGAVariable((Variable)counter)) {
                throw new IllegalArgumentException("Counter variable " + counter + " is not scalar. Please use " + counter + " only as counter variable and do not assign Geometric Algebra expressions to it.");
            }
            loop.setCounterVariable(counter);
            this.graph.removeLocalVariable(counter);
            this.graph.addScalarVariable(counter);
        }
        return loop;
    }

    public BreakNode handleBreak() {
        BreakNode brk = new BreakNode(this.graph);
        this.addNode((SequentialNode)brk);
        return brk;
    }

    public Macro handleMacroDefinition(String id, List<SequentialNode> body, Expression ret) {
        this.currentMacroDefinition = "";
        Macro macro = new Macro(this.graph, id, body, ret);
        this.addNode((SequentialNode)macro);
        this.graph.addMacro(macro);
        this.rewireNodes(body, (SequentialNode)macro);
        return macro;
    }

    public void addMacroName(String name) {
        String hashname = NameTable.getInstance().add(name);
        this.macros.add(hashname);
        this.currentMacroDefinition = hashname;
    }

    private void rewireNodes(List<SequentialNode> list, SequentialNode base) {
        if (list == null || list.size() == 0) {
            return;
        }
        Iterator<SequentialNode> it = list.iterator();
        SequentialNode current = it.next();
        this.graph.removeNode(current);
        current.addPredecessor((Node)base);
        while (it.hasNext()) {
            SequentialNode next = it.next();
            this.graph.removeNode(next);
            current.replaceSuccessor(current.getSuccessor(), (Node)next);
            next.addPredecessor((Node)current);
            current = next;
        }
        current.replaceSuccessor(current.getSuccessor(), (Node)new BlockEndNode(this.graph, base));
    }

    protected int getNumberOfAssignments() {
        return this.assignments;
    }

    public AssignmentNode handleAssignment(Variable variable, Expression expression) {
        this.checkIllegalVariable(variable);
        CheckGAVisitor gaVisitor = new CheckGAVisitor();
        expression.accept((ExpressionVisitor)gaVisitor);
        if (gaVisitor.isGA()) {
            // empty if block
        }
        AssignmentNode assignment = new AssignmentNode(this.graph, variable, expression);
        this.addNode((SequentialNode)assignment);
        return assignment;
    }

    public AssignmentNode handleAssignment(String name, Expression expression) {
        return this.handleAssignment(new Variable(name), expression);
    }

    public void handleProcedure(String name) {
    }

    public StoreResultNode handlePrint(Expression variable) {
        if (variable instanceof Variable) {
            StoreResultNode storeResult = new StoreResultNode(this.graph, (Variable)variable);
            this.addNode((SequentialNode)storeResult);
            return storeResult;
        }
        throw new IllegalArgumentException("Only variables can be marked for optimization.");
    }

    public IfThenElseNode handleIfStatement(Expression condition, List<SequentialNode> then_part, List<SequentialNode> else_part) {
        IfThenElseNode ifthenelse = new IfThenElseNode(this.graph, condition);
        this.addNode((SequentialNode)ifthenelse);
        this.rewireNodes(then_part, ifthenelse);
        this.rewireNodes(else_part, ifthenelse);
        ifthenelse.setPositive(then_part.get(0));
        ifthenelse.setNegative((SequentialNode)(else_part != null && else_part.size() > 0 ? else_part.get(0) : new BlockEndNode(this.graph, this.lastNode)));
        return ifthenelse;
    }

    private void rewireNodes(List<SequentialNode> list, IfThenElseNode base) {
        if (list == null || list.size() == 0) {
            return;
        }
        Iterator<SequentialNode> it = list.iterator();
        SequentialNode current = it.next();
        this.graph.removeNode(current);
        current.addPredecessor((Node)base);
        while (it.hasNext()) {
            SequentialNode next = it.next();
            this.graph.removeNode(next);
            current.replaceSuccessor(current.getSuccessor(), (Node)next);
            next.addPredecessor((Node)current);
            current = next;
        }
        current.replaceSuccessor(current.getSuccessor(), (Node)new BlockEndNode(this.graph, current));
    }

    private void findUndeclaredVariables(Expression expression) {
        UsedVariablesVisitor visitor = new UsedVariablesVisitor();
        expression.accept((ExpressionVisitor)visitor);
        for (Variable usedVariable : visitor.getVariables()) {
            if (this.graph.getLocalVariables().contains(usedVariable)) continue;
            if (this.graph.getPragmaMinValue().containsKey(usedVariable.getName())) {
                usedVariable.setMinValue((String)this.graph.getPragmaMinValue().get(usedVariable.getName()));
            }
            if (this.graph.getPragmaMaxValue().containsKey(usedVariable.getName())) {
                usedVariable.setMaxValue((String)this.graph.getPragmaMaxValue().get(usedVariable.getName()));
            }
            this.graph.addInputVariable(usedVariable);
        }
    }

    public Expression processIdentifier(String name) {
        return new Variable(name);
    }

    public Expression processFunction(String name, List<Expression> args) {
        return new MacroCall(name, args);
    }

    public SequentialNode handleDefGaalet(String name, ArrayList<String> blades, ArrayList<Expression> expression) {
        ++this.assignments;
        String hashname = NameTable.getInstance().add(name);
        GaaletMultiVector muVec = new GaaletMultiVector(hashname);
        for (int n = 0; n < expression.size(); ++n) {
            int number;
            this.findUndeclaredVariables(expression.get(n));
            String hex = blades.get(n);
            if (hex.length() > 1 && hex.charAt(1) == 'x') {
                hex = hex.substring(2);
                number = Integer.valueOf(hex, 16);
            } else {
                number = new Integer(hex);
            }
            muVec.addGaaletTupel(number, expression.get(n));
        }
        Variable variable = new Variable(hashname);
        AssignmentNode assignment = new AssignmentNode(this.graph, variable, muVec.getExpression());
        this.addNode((SequentialNode)assignment);
        this.vectorSet.put(hashname, muVec);
        this.wasDefined(hashname);
        System.out.println(muVec.getExpression());
        return assignment;
    }

    public SequentialNode bladeAssignment(String name, String index, Expression expression) {
        ++this.assignments;
        this.findUndeclaredVariables(expression);
        System.out.println("Blade Assignment");
        Integer number = new Integer(index);
        String hashname = NameTable.getInstance().add(name);
        if (this.vectorSet.get(hashname) == null) {
            System.err.println("Definition of variable " + name + " needed!!!");
        }
        int gealgBlade = this.vectorSet.get(hashname).get(number);
        MultivectorComponent variable = new MultivectorComponent(hashname, gealgBlade);
        AssignmentNode assignment = new AssignmentNode(this.graph, (Variable)variable, expression);
        this.addNode((SequentialNode)assignment);
        return assignment;
    }

    public void defineMV(String name, ArrayList<String> blades) {
        String hashname = NameTable.getInstance().add(name);
        GaaletMultiVector variable = new GaaletMultiVector(hashname);
        this.vectorSet.put(hashname, variable);
        for (String blade : blades) {
            this.vectorSet.get(hashname).addGaaletBlades(blade);
        }
        this.wasDefined(hashname);
    }

    public MultivectorComponent blade(String name, String blade) {
        int index = new Integer(blade);
        String hashname = NameTable.getInstance().add(name);
        int gealgBlade = this.vectorSet.get(hashname).get(index);
        return new MultivectorComponent(hashname, gealgBlade);
    }

    public void finish() {
        SetCallerVisitor visitor = new SetCallerVisitor();
        this.graph.accept((ControlFlowVisitor)visitor);
        SetLocalAndInputVariables inputFinder = new SetLocalAndInputVariables();
        this.graph.accept((ControlFlowVisitor)inputFinder);
    }

    public void wasDefined(String variableName) {
        this.graph.addLocalVariable(new Variable(variableName));
    }

    public void wasDefined(Variable variable) {
        this.wasDefined(variable.getName());
    }

    private class SetLocalAndInputVariables
    implements ControlFlowVisitor {
        SetLocalAndInputVariables() {
        }

        private void findUndeclaredVariables(Expression expression) {
            UsedVariablesVisitor visitor = new UsedVariablesVisitor();
            expression.accept((ExpressionVisitor)visitor);
            for (Variable usedVariable : visitor.getVariables()) {
                GraphBuilder.this.checkIllegalVariable(usedVariable);
                if (GraphBuilder.this.graph.getLocalVariables().contains(usedVariable)) continue;
                if (GraphBuilder.this.graph.getPragmaMinValue().containsKey(usedVariable.getName())) {
                    usedVariable.setMinValue((String)GraphBuilder.this.graph.getPragmaMinValue().get(usedVariable.getName()));
                }
                if (GraphBuilder.this.graph.getPragmaMaxValue().containsKey(usedVariable.getName())) {
                    usedVariable.setMaxValue((String)GraphBuilder.this.graph.getPragmaMaxValue().get(usedVariable.getName()));
                }
                GraphBuilder.this.graph.addInputVariable(usedVariable);
            }
        }

        public void visit(StartNode node) {
            node.getSuccessor().accept((ControlFlowVisitor)this);
        }

        public void visit(AssignmentNode node) {
            this.findUndeclaredVariables(node.getValue());
            node.getSuccessor().accept((ControlFlowVisitor)this);
        }

        public void visit(StoreResultNode node) {
            this.findUndeclaredVariables((Expression)node.getValue());
            node.getSuccessor().accept((ControlFlowVisitor)this);
        }

        public void visit(IfThenElseNode node) {
            this.findUndeclaredVariables(node.getCondition());
            node.getPositive().accept((ControlFlowVisitor)this);
            node.getNegative().accept((ControlFlowVisitor)this);
            node.getSuccessor().accept((ControlFlowVisitor)this);
        }

        public void visit(BlockEndNode node) {
        }

        public void visit(LoopNode node) {
            node.getBody().accept((ControlFlowVisitor)this);
            node.getSuccessor().accept((ControlFlowVisitor)this);
        }

        public void visit(BreakNode node) {
        }

        public void visit(Macro node) {
            node.getSuccessor().accept((ControlFlowVisitor)this);
        }

        public void visit(ExpressionStatement node) {
            this.findUndeclaredVariables(node.getExpression());
            node.getSuccessor().accept((ControlFlowVisitor)this);
        }

        public void visit(EndNode node) {
        }

        public void visit(ColorNode node) {
            node.getSuccessor().accept((ControlFlowVisitor)this);
        }
    }
}

