/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.gaalet.output;

import de.gaalop.CodeGenerator;
import de.gaalop.OutputFile;
import de.gaalop.cfg.ControlFlowGraph;
import de.gaalop.cfg.ControlFlowVisitor;
import de.gaalop.gaalet.output.CppVisitor;
import de.gaalop.gaalet.output.Plugin;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Set;

public class CppCodeGenerator
implements CodeGenerator {
    private final Plugin plugin;

    CppCodeGenerator(Plugin plugin) {
        this.plugin = plugin;
    }

    public Set<OutputFile> generate(ControlFlowGraph in) {
        String code = this.generateCode(in);
        String filename = this.generateFilename(in);
        OutputFile sourceFile = new OutputFile(filename, code, Charset.forName("UTF-8"));
        return Collections.singleton(sourceFile);
    }

    private String generateFilename(ControlFlowGraph in) {
        String filename = "gaalop.c";
        if (in.getSource() != null) {
            filename = in.getSource().getName();
            int lastDotIndex = filename.lastIndexOf(46);
            if (lastDotIndex != -1) {
                filename = filename.substring(0, lastDotIndex);
            }
            filename = filename + ".c";
        }
        return filename;
    }

    private String generateCode(ControlFlowGraph in) {
        CppVisitor visitor = new CppVisitor(this.plugin.getVariableType());
        in.accept((ControlFlowVisitor)visitor);
        return visitor.getCode();
    }
}

