/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.gaalet.output;

import de.gaalop.NameTable;
import de.gaalop.StringList;
import de.gaalop.cfg.AssignmentNode;
import de.gaalop.cfg.ControlFlowVisitor;
import de.gaalop.cfg.StartNode;
import de.gaalop.dfg.ExpressionVisitor;
import de.gaalop.dfg.Variable;
import de.gaalop.gaalet.GaaletMultiVector;
import de.gaalop.gaalet.output.FieldsUsedVisitor;
import java.util.HashSet;
import java.util.Set;

public class CppVisitor
extends de.gaalop.cpp.CppVisitor {
    private String suffix = "_opt";
    private boolean ifPossible = true;
    protected Set<GaaletMultiVector> vectorSet = new HashSet<GaaletMultiVector>();

    public CppVisitor(boolean standalone) {
        super(standalone);
    }

    public CppVisitor(String variableType) {
        super(false);
        this.variableType = variableType;
    }

    protected void printVarName(String key) {
        this.code.append(NameTable.getInstance().get(key));
    }

    public void visit(StartNode node) {
        this.graph = node.getGraph();
        if (this.standalone) {
            this.code.append("void calculate(");
            StringList list = new StringList();
            for (String var : this.graph.getInputs()) {
                list.add((Object)(this.variableType + " " + NameTable.getInstance().get(var)));
            }
            for (String var : this.graph.getOutputs()) {
                list.add((Object)(this.variableType + NameTable.getInstance().get(var + this.suffix)));
            }
            this.code.append(list.join());
            this.code.append(") {\n");
            ++this.indentation;
        }
        if (this.ifPossible && !this.standalone) {
            FieldsUsedVisitor fieldVisitor;
            for (String var : this.graph.getInputs()) {
                fieldVisitor = new FieldsUsedVisitor(var);
                this.graph.accept((ControlFlowVisitor)fieldVisitor);
                this.code.append("// This is input: ");
                this.code.append(fieldVisitor.giveDefinition(this.variableType));
                this.code.append("\n");
            }
            this.code.append("\n");
            for (String var : this.graph.getOutputs()) {
                fieldVisitor = new FieldsUsedVisitor(var);
                this.graph.accept((ControlFlowVisitor)fieldVisitor);
                this.code.append("// This is output: ");
                this.code.append(fieldVisitor.giveDefinition());
                this.code.append("\n");
            }
        }
        this.handleLocalVariables();
        this.createVectorSet();
        node.getSuccessor().accept((ControlFlowVisitor)this);
    }

    protected void createVectorSet() {
        FieldsUsedVisitor fieldVisitor;
        for (String var : this.graph.getInputs()) {
            fieldVisitor = new FieldsUsedVisitor(var);
            this.graph.accept((ControlFlowVisitor)fieldVisitor);
            this.vectorSet.add(fieldVisitor.getMultiVector());
        }
        for (String var : this.graph.getLocals()) {
            fieldVisitor = new FieldsUsedVisitor(var);
            this.graph.accept((ControlFlowVisitor)fieldVisitor);
            this.vectorSet.add(fieldVisitor.getMultiVector());
        }
        for (String var : this.graph.getOutputs()) {
            fieldVisitor = new FieldsUsedVisitor(var);
            this.graph.accept((ControlFlowVisitor)fieldVisitor);
            this.vectorSet.add(fieldVisitor.getMultiVector());
        }
    }

    protected void handleLocalVariables() {
        HashSet<String> varNames = new HashSet<String>();
        for (Variable variable : this.graph.getLocalVariables()) {
            varNames.add(variable.getName());
        }
        for (String string : varNames) {
            this.appendIndentation();
            FieldsUsedVisitor fieldVisitor = new FieldsUsedVisitor(string);
            this.graph.accept((ControlFlowVisitor)fieldVisitor);
            this.code.append(fieldVisitor.giveDefinition(this.variableType));
            this.code.append("\n");
        }
        if (!this.graph.getLocalVariables().isEmpty()) {
            this.code.append("\n");
        }
    }

    public void visit(AssignmentNode node) {
        if (this.assigned.contains(node.getVariable().getName())) {
            this.log.warn((Object)("Reuse of variable " + node.getVariable().getName() + ". Make sure to reset this variable or use another name."));
            this.code.append("\n");
            this.appendIndentation();
            this.code.append("// Warning: reuse of variable ");
            this.code.append(node.getVariable().getName());
            this.code.append(".\n");
            this.appendIndentation();
            this.code.append("// Make sure to reset this variable or use another name.\n");
            this.assigned.remove(node.getVariable().getName());
        }
        this.appendIndentation();
        node.getVariable().accept((ExpressionVisitor)this);
        this.code.append(" = ");
        node.getValue().accept((ExpressionVisitor)this);
        this.code.append(";\n");
        node.getSuccessor().accept((ControlFlowVisitor)this);
    }
}

