/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.gaalet.output;

import de.gaalop.NameTable;
import de.gaalop.cfg.AssignmentNode;
import de.gaalop.cfg.BlockEndNode;
import de.gaalop.cfg.BreakNode;
import de.gaalop.cfg.ColorNode;
import de.gaalop.cfg.ControlFlowVisitor;
import de.gaalop.cfg.EndNode;
import de.gaalop.cfg.ExpressionStatement;
import de.gaalop.cfg.IfThenElseNode;
import de.gaalop.cfg.LoopNode;
import de.gaalop.cfg.Macro;
import de.gaalop.cfg.StartNode;
import de.gaalop.cfg.StoreResultNode;
import de.gaalop.dfg.Addition;
import de.gaalop.dfg.BaseVector;
import de.gaalop.dfg.Division;
import de.gaalop.dfg.Equality;
import de.gaalop.dfg.Exponentiation;
import de.gaalop.dfg.ExpressionVisitor;
import de.gaalop.dfg.FloatConstant;
import de.gaalop.dfg.FunctionArgument;
import de.gaalop.dfg.Inequality;
import de.gaalop.dfg.InnerProduct;
import de.gaalop.dfg.LogicalAnd;
import de.gaalop.dfg.LogicalNegation;
import de.gaalop.dfg.LogicalOr;
import de.gaalop.dfg.MacroCall;
import de.gaalop.dfg.MathFunctionCall;
import de.gaalop.dfg.Multiplication;
import de.gaalop.dfg.MultivectorComponent;
import de.gaalop.dfg.Negation;
import de.gaalop.dfg.OuterProduct;
import de.gaalop.dfg.Relation;
import de.gaalop.dfg.Reverse;
import de.gaalop.dfg.Subtraction;
import de.gaalop.dfg.Variable;
import de.gaalop.gaalet.GaaletMultiVector;
import java.util.LinkedList;
import java.util.List;

public class FieldsUsedVisitor
implements ControlFlowVisitor,
ExpressionVisitor {
    private GaaletMultiVector multivector;
    private static String DEFAULT_VARIABLE_TYPE = "double";

    public FieldsUsedVisitor(String name) {
        this.multivector = new GaaletMultiVector(name);
    }

    public List<Integer> getBladeList() {
        LinkedList<Integer> result = new LinkedList<Integer>(this.multivector.getGaalopBlades().keySet());
        return result;
    }

    public GaaletMultiVector getMultiVector() {
        return this.multivector;
    }

    private String printVarName(String key) {
        return NameTable.getInstance().get(key);
    }

    public String giveDefinition() {
        return this.giveDefinition(DEFAULT_VARIABLE_TYPE);
    }

    public String giveDefinition(String variableType) {
        String definition;
        int size = this.multivector.getGaalopBlades().size();
        if (size == 0) {
            definition = variableType + " ";
            definition = definition + this.printVarName(this.multivector.getName()) + ";";
        } else {
            definition = "gaalet::cm::mv<";
            definition = definition + this.createHexString();
            definition = definition + ">::type " + this.printVarName(this.multivector.getName()) + ';';
        }
        return definition;
    }

    private String createHexString() {
        return this.multivector.getDefinition();
    }

    public void visit(MultivectorComponent node) {
        String nameNode;
        String nameMV = this.multivector.getName().replace("_opt", "");
        if (nameMV.equals(nameNode = node.getName().replace("_opt", ""))) {
            this.multivector.addComponent(node.getBladeIndex());
        }
    }

    public void visit(Subtraction node) {
        node.getLeft().accept((ExpressionVisitor)this);
        node.getRight().accept((ExpressionVisitor)this);
    }

    public void visit(Addition node) {
        node.getLeft().accept((ExpressionVisitor)this);
        node.getRight().accept((ExpressionVisitor)this);
    }

    public void visit(Division node) {
        node.getLeft().accept((ExpressionVisitor)this);
        node.getRight().accept((ExpressionVisitor)this);
    }

    public void visit(InnerProduct node) {
        node.getLeft().accept((ExpressionVisitor)this);
        node.getRight().accept((ExpressionVisitor)this);
    }

    public void visit(Multiplication node) {
        node.getLeft().accept((ExpressionVisitor)this);
        node.getRight().accept((ExpressionVisitor)this);
    }

    public void visit(MathFunctionCall node) {
        node.getOperand().accept((ExpressionVisitor)this);
    }

    public void visit(Variable node) {
    }

    public void visit(FloatConstant node) {
    }

    public void visit(OuterProduct node) {
        node.getLeft().accept((ExpressionVisitor)this);
        node.getRight().accept((ExpressionVisitor)this);
    }

    public void visit(BaseVector node) {
    }

    public void visit(Negation node) {
        node.getOperand().accept((ExpressionVisitor)this);
    }

    public void visit(Reverse node) {
        node.getOperand().accept((ExpressionVisitor)this);
    }

    public void visit(LogicalOr node) {
        node.getLeft().accept((ExpressionVisitor)this);
        node.getRight().accept((ExpressionVisitor)this);
    }

    public void visit(LogicalAnd node) {
        node.getLeft().accept((ExpressionVisitor)this);
        node.getRight().accept((ExpressionVisitor)this);
    }

    public void visit(Equality node) {
        node.getLeft().accept((ExpressionVisitor)this);
        node.getRight().accept((ExpressionVisitor)this);
    }

    public void visit(Inequality node) {
        node.getLeft().accept((ExpressionVisitor)this);
        node.getRight().accept((ExpressionVisitor)this);
    }

    public void visit(Relation relation) {
        relation.getLeft().accept((ExpressionVisitor)this);
        relation.getRight().accept((ExpressionVisitor)this);
    }

    public void visit(Exponentiation node) {
        node.getLeft().accept((ExpressionVisitor)this);
        node.getRight().accept((ExpressionVisitor)this);
    }

    public void visit(StartNode node) {
        node.getSuccessor().accept((ControlFlowVisitor)this);
    }

    public void visit(AssignmentNode node) {
        node.getValue().accept((ExpressionVisitor)this);
        node.getVariable().accept((ExpressionVisitor)this);
        node.getSuccessor().accept((ControlFlowVisitor)this);
    }

    public void visit(StoreResultNode node) {
        node.getSuccessor().accept((ControlFlowVisitor)this);
    }

    public void visit(IfThenElseNode node) {
        node.getCondition().accept((ExpressionVisitor)this);
        node.getPositive().accept((ControlFlowVisitor)this);
        node.getNegative().accept((ControlFlowVisitor)this);
        node.getSuccessor().accept((ControlFlowVisitor)this);
    }

    public void visit(BlockEndNode node) {
    }

    public void visit(EndNode node) {
    }

    public void visit(LogicalNegation node) {
    }

    public void visit(FunctionArgument node) {
    }

    public void visit(MacroCall node) {
    }

    public void visit(LoopNode node) {
        node.getCounterVariable().accept((ExpressionVisitor)this);
        node.getBody().accept((ControlFlowVisitor)this);
        node.getSuccessor().accept((ControlFlowVisitor)this);
    }

    public void visit(BreakNode node) {
        node.getSuccessor().accept((ControlFlowVisitor)this);
    }

    public void visit(Macro node) {
        node.getSuccessor().accept((ControlFlowVisitor)this);
    }

    public void visit(ExpressionStatement node) {
        node.getSuccessor().accept((ControlFlowVisitor)this);
    }

    public void visit(ColorNode node) {
        node.getSuccessor().accept((ControlFlowVisitor)this);
    }
}

