/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.gaalet.output;

import de.gaalop.dfg.Addition;
import de.gaalop.dfg.Division;
import de.gaalop.dfg.Exponentiation;
import de.gaalop.dfg.Expression;
import de.gaalop.dfg.FloatConstant;
import de.gaalop.dfg.MathFunctionCall;
import de.gaalop.dfg.Multiplication;
import de.gaalop.dfg.MultivectorComponent;
import de.gaalop.dfg.Negation;
import de.gaalop.dfg.Relation;
import de.gaalop.dfg.Subtraction;
import de.gaalop.dfg.Variable;
import java.util.HashMap;
import java.util.Map;

public class OperatorPriority {
    private static final Map<Class<? extends Expression>, Integer> OPERATOR_PRIORITY = new HashMap<Class<? extends Expression>, Integer>();

    public static boolean hasLowerPriority(Expression parent, Expression child) {
        Integer parentPriority = OPERATOR_PRIORITY.get(parent.getClass());
        Integer childPriority = OPERATOR_PRIORITY.get(child.getClass());
        if (parentPriority == null || childPriority == null) {
            return true;
        }
        return childPriority < parentPriority;
    }

    static {
        OPERATOR_PRIORITY.put(FloatConstant.class, 1000);
        OPERATOR_PRIORITY.put(Variable.class, 1000);
        OPERATOR_PRIORITY.put(MultivectorComponent.class, 1000);
        OPERATOR_PRIORITY.put(MathFunctionCall.class, 1000);
        OPERATOR_PRIORITY.put(Exponentiation.class, 1000);
        OPERATOR_PRIORITY.put(Negation.class, 990);
        OPERATOR_PRIORITY.put(Multiplication.class, 960);
        OPERATOR_PRIORITY.put(Division.class, 960);
        OPERATOR_PRIORITY.put(Subtraction.class, 950);
        OPERATOR_PRIORITY.put(Addition.class, 950);
        OPERATOR_PRIORITY.put(Relation.class, 940);
    }
}

